//
//  PatrolExamSelectTableViewCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamSelectTableViewCell.h"

@implementation PatrolExamSelectTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)actionNotiAnswerChanged:(NSNotification *)noti {
    PatrolExamCellViewModel *cellModel = noti.object;
    if (![cellModel.question.uuid isEqualToString:self.cellModel.question.uuid]) {
        return;
    }
    //根据类型改变复选框的状态
    if (self.cellModel.cellType == ExamCellTypeSingle ||
        self.cellModel.cellType == ExamCellTypeSelectScore) {
        if ([cellModel.questionDetail.index isEqualToNumber:self.cellModel.questionDetail.index]) {
            self.btnCheckBox.selected = YES;
        } else {
            self.btnCheckBox.selected = NO;
        }

    } else if (cellModel.cellType == ExamCellTypeMultiple) {
        if ([cellModel.questionDetail.index isEqualToNumber:self.cellModel.questionDetail.index]) {
            self.btnCheckBox.selected = !self.btnCheckBox.isSelected;
        }
    }
}

- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    self.labelContent.text = cellModel.questionDetail.value;
    [self configWithCellType];

    
    if (cellModel.answer.details.count > 0) {
        for (ZJPatrolDetail_results_answers_details *detail in cellModel.answer.details) {
            if ([cellModel.questionDetail.index isEqualToNumber:detail.index]) {
                self.btnCheckBox.selected = YES;
                return;
            } else {
                self.btnCheckBox.selected = NO;
            }
        }
    } else {
        self.btnCheckBox.selected = NO;
    }
}


- (void)configWithCellType {
    //单选题或者单选打分题，复选框是圆形的
    if (self.cellModel.cellType == ExamCellTypeSingle ||
        self.cellModel.cellType == ExamCellTypeSelectScore) {
        [self.btnCheckBox setImage:TCImage(@"patrol_exam_radio_unselected") forState:UIControlStateNormal];
        [self.btnCheckBox setImage:TCImage(@"patrol_exam_radio_selected") forState:UIControlStateSelected];
        
        //多选题，复选框是方形的
    } else if (self.cellModel.cellType == ExamCellTypeMultiple) {
        [self.btnCheckBox setImage:TCImage(@"patrol_exam_radio2_unselect") forState:UIControlStateNormal];
        [self.btnCheckBox setImage:TCImage(@"patrol_exam_radio2_select") forState:UIControlStateSelected];
    }
}


- (IBAction)actionSelect:(id)sender {
    ZJPatrolDetail_results_answers *answer = self.cellModel.getAnswer;

    //选中当前cell
    if (self.cellModel.cellType == ExamCellTypeSelectScore ||
        self.cellModel.cellType == ExamCellTypeSingle) {
        if (answer.details.count == 0) {
            answer.details = (NSMutableArray<ZJPatrolDetail_results_answers_details, Optional> *) [NSMutableArray array];
            ZJPatrolDetail_results_answers_details *detail = [ZJPatrolDetail_results_answers_details new];
            [answer.details addObject:detail];
        }

        ZJPatrolDetail_results_answers_details *detail = answer.details[0];
        detail.index = self.cellModel.questionDetail.index;

    } else if (self.cellModel.cellType == ExamCellTypeMultiple) {

        //如果存在点击中的问题选项的下标，则停止循环并移除这个答案

        //是否存在点击中问题选项
        BOOL isExist = NO;
        for (ZJPatrolDetail_results_answers_details *detail in answer.details) {
            if ([detail.index isEqualToNumber:self.cellModel.questionDetail.index]) {
                [answer.details removeObject:detail];
                isExist = YES;
                break;
            }
        }

        if (!isExist) {
            ZJPatrolDetail_results_answers_details *detail = [ZJPatrolDetail_results_answers_details new];
            detail.index = self.cellModel.questionDetail.index;
            [answer.details addObject:detail];
        }
        
        //如果全部不选，则代表这一题没有回答过
        if (answer.details.count == 0) {
            [self.cellModel.viewModel.dicAnswers removeObjectForKey:self.cellModel.question.uuid];
        }
    }

    [self.cellModel postNoti];

    self.cellModel.viewModel.blockAnswerAction();
        

}

@end
