//
//  PatrolExamStarCell.m
//  patrol
//
//  Created by Javen on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolExamStarCell.h"
#import "QuestionStarTableViewCell.h"

@implementation PatrolExamStarCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        CGFloat offsetX = 15;//边界距离
        ASStarRatingView *starView = [[ASStarRatingView alloc] initWithFrame:CGRectMake(offsetX, 10, ScreenSize.width-(offsetX * 2), 20)];
        starView.canEdit = YES;
        starView.selectedStar = TCImage(@"patrol_exam_blue_star");
        starView.notSelectedStar = TCImage(@"patrol_exam_gray_star");
        starView.halfSelectedStar = TCImage(@"patrol_exam_blue_star");
        starView.rating = 0;
        self.starView = starView;
        [self.contentView addSubview:starView];
    }
    return self;
}


- (void)setCellModel:(PatrolExamCellViewModel *)cellModel {
    [super setCellModel:cellModel];
    self.starView.maxRating = [cellModel.question.star floatValue];
    self.starView.rating = cellModel.answer.score.integerValue * (cellModel.question.star.doubleValue / cellModel.question.standScore.doubleValue);
    @weakify(self);
    [self.starView setBlockStarRefreshed:^(float rating) {
        @strongify(self);
        if (rating == 0) {
            return ;
        }
        ZJPatrolDetail_results_answers *answer = self.cellModel.getAnswer;
        answer.score = @(rating/(cellModel.question.star.doubleValue / cellModel.question.standScore.doubleValue));
        self.cellModel.viewModel.blockAnswerAction();
        [self.cellModel postNoti];
    }];
}


@end
