//
//  GTOHomeSyncItem.m
//  total
//  未读公告和同步数据提醒
//  Created by freecui on 15/10/12.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOHomeSyncItem.h"
@interface GTOHomeSyncItem ()
@property(nonatomic, strong) UIButton *announcementBtn;
@property(nonatomic, strong) UIButton *synchronizationBtn;

@end
@implementation GTOHomeSyncItem
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self){
        return nil;
    }
    [self initSubviews];
    return self;
}
- (void) initSubviews {
   // self.backgroundColor = [UIColor blueColor];
    
    self.announcementBtn = [self p_buttonWithImageName:nil];
    self.announcementBtn.userInteractionEnabled = NO;
    self.synchronizationBtn = [self p_buttonWithImageName:nil];
    self.synchronizationBtn.userInteractionEnabled = NO;

    self.closeBtn = [self p_buttonWithImageName:nil];
 

    [self addSubview:_announcementBtn];
    [self addSubview:_synchronizationBtn];
    [self addSubview:_closeBtn];
}
- (void)layoutSubviews {
    CGFloat btnH = 22;
    CGFloat padding = 10;
    CGFloat closeBtnW = 40;
    self.closeBtn.frame = ((CGRect){
            .origin.x = self.width - closeBtnW,
            .origin.y = GTO_VERTICAL_PADDING,
            .size.width = closeBtnW,
            .size.height = btnH
    });
    self.announcementBtn.frame = ((CGRect){
            .origin.x = padding,
            .origin.y = _closeBtn.y,
            .size.width = self.width - 2 * padding - closeBtnW,
            .size.height = btnH
    });
    self.synchronizationBtn.frame = ((CGRect){
            .origin.x = _announcementBtn.x ,
            .origin.y = _announcementBtn.bottom + GTO_VERTICAL_PADDING,
            .size.width = self.width - 2 * padding,
            .size.height = btnH
    });

}

- (UIButton *)p_buttonWithImageName: (NSString *)imgName {
    UIButton *btn = [[UIButton alloc] init];
    [btn setImage:[UIImage imageNamed:imgName] forState:UIControlStateNormal];
    [btn.titleLabel setFont:[UIFont systemFontOfSize:15]];
    //[btn setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    return btn;
}

@end
@implementation GTOHomeSyncItem (configure)
- (void)updateWithData {
    [self.announcementBtn setTitle:@"您有3条未读公告" forState:UIControlStateNormal];
    [self.synchronizationBtn setTitle:@"您有未同步的数据，请下拉同步" forState:UIControlStateNormal];
    [self layoutSubviews];
}
@end
