//
//  GTOHomeWarnItem.m
//  total
// 代办事项提醒
//  Created by freecui on 15/10/12.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOHomeWarnItem.h"
@interface GTOHomeWarnItem ()
@property(nonatomic, strong) IBTUILabel *HSELabel;
@property(nonatomic, strong) IBTUILabel *checkLabel;
@property(nonatomic, strong) IBTUILabel *HSETimeLabel;
@property(nonatomic, strong) IBTUILabel *checkTimeLabel;

@end
@implementation GTOHomeWarnItem

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self){
        return nil;
    }
    [self initSubviews];
    return self;
}
- (void)initSubviews {
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.HSELabel = [[IBTUILabel alloc] initWithfont:font
                                           tintColor:GTO_GRAY_TINT_COLOR
                                     backgroundColor:nil
                                       textAlignment:NSTextAlignmentLeft];
    self.checkLabel = [[IBTUILabel alloc] initWithfont:font
                                           tintColor:GTO_GRAY_TINT_COLOR
                                     backgroundColor:nil
                                       textAlignment:NSTextAlignmentLeft];
    self.HSETimeLabel = [[IBTUILabel alloc] initWithfont:font
                                           tintColor:GTO_GRAY_TINT_COLOR
                                     backgroundColor:nil
                                       textAlignment:NSTextAlignmentLeft];
    self.checkTimeLabel = [[IBTUILabel alloc] initWithfont:font
                                           tintColor:GTO_GRAY_TINT_COLOR
                                     backgroundColor:nil
                                       textAlignment:NSTextAlignmentLeft];

    [self addSubview:_HSELabel];
    [self addSubview:_checkLabel];
    [self addSubview:_HSETimeLabel];
    [self addSubview:_checkTimeLabel];


}
- (void)layoutSubviews {
    [super layoutSubviews];
    CGFloat lblW = self.lineView.width * 0.6;
    self.HSELabel.frame = ((CGRect){
            .origin.x = LEFT_PADDING,
            .origin.y = self.lineView.bottom + VERTICAL_PADDING,
            .size.width = lblW,
            .size.height = LBL_HEIGHT
    });
    self.checkLabel.frame = ((CGRect){
            .origin.x = _HSELabel.x ,
            .origin.y = _HSELabel.bottom + VERTICAL_PADDING,
            .size.width = _HSELabel.width,
            .size.height = LBL_HEIGHT
    });
    self.HSETimeLabel.frame = ((CGRect){
            .origin.x = _HSELabel.right,
            .origin.y = _HSELabel.y,
            .size.width = self.lineView.width - _HSELabel.width,
            .size.height = LBL_HEIGHT
    });
    self.checkTimeLabel.frame = ((CGRect){
            .origin.x = _HSETimeLabel.x ,
            .origin.y = _checkLabel.y,
            .size.width = _HSETimeLabel.width,
            .size.height = LBL_HEIGHT
    });

}
@end

@implementation GTOHomeWarnItem (configure)
- (void)updateWithData {
    self.titleLabel.text = @"待办事项提醒";
    self.HSELabel.text = @"2015年HSE季度VI检查";
    self.HSETimeLabel.text = @"07-01 ~ 09-30";
    self.checkLabel.text = @"2015年HSE季度VI检查";
    self.checkTimeLabel.text = @"07-01 ~ 09-30";
}
@end

/*
 - (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self){
        return nil;
    }
    [self initSubviews];
    return self;
}
- (void)initSubviews {

}
* */
