//
//  ICRAboutViewController.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/8.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define IBT_APP_ICON_WIDTH     (80)

#import "ICRAboutViewController.h"

@interface ICRAboutViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;
@property (strong, nonatomic) UIImageView *m_viewAvatarImage;

@end

@implementation ICRAboutViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initTableViewInfo];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initTableViewInfo {
    
    self.title = [IBTCommon localizableString:@"About"];
    
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    [self.view addSubview:tableV];
    
    
    IBTUIView *tableHeader = [[IBTUIView alloc] init];
    tableHeader.backgroundColor = [UIColor clearColor];
    tableHeader.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = tableV.width,
        .size.height = 160
    };
    
    CGFloat fNameH = 40;
    self.m_viewAvatarImage = [[UIImageView alloc] init];
    _m_viewAvatarImage.frame = (CGRect){
        .origin.x = (tableHeader.width - IBT_APP_ICON_WIDTH) * .5f,
        .origin.y = (tableHeader.height - IBT_APP_ICON_WIDTH - fNameH) * IBT_GOLDEN_RATIO,
        .size.width = IBT_APP_ICON_WIDTH,
        .size.height = IBT_APP_ICON_WIDTH
    };
    _m_viewAvatarImage.layer.cornerRadius = IBT_APP_ICON_WIDTH / 10;
    _m_viewAvatarImage.layer.masksToBounds = YES;
    
    CGFloat fMargin = 10;
    UILabel *appNameLabel = [[UILabel alloc] init];
    appNameLabel.frame = (CGRect){
        .origin.x = fMargin,
        .origin.y = _m_viewAvatarImage.bottom,
        .size.width = tableHeader.width - 2 * fMargin,
        .size.height = fNameH
    };
    
    appNameLabel.font = [UIFont boldSystemFontOfSize:18];
    appNameLabel.textColor = IBT_TINTCOLOR;
    appNameLabel.textAlignment = NSTextAlignmentCenter;
    
    [tableHeader addSubview:_m_viewAvatarImage];
    [tableHeader addSubview:appNameLabel];
    
    tableV.tableHeaderView = tableHeader;
    
    
    // Footer
    CGRect frame = self.view.frame;
    frame.size.height = 20;
    frame.origin.y = self.view.height - CGRectGetHeight(frame) -20;
    
    UILabel *label = [[UILabel alloc] initWithFrame:frame];
    label.font = [UIFont systemFontOfSize:16];
    label.text = @"Copyright@2014";
    label.backgroundColor = [UIColor clearColor];
    label.textAlignment = NSTextAlignmentCenter;
    label.autoresizingMask = UIViewAutoresizingFlexibleTopMargin;
    
    //tableV.tableFooterView = label;
    [self.view addSubview:label];
    
    /*
     CFBundleIcons =     {
     CFBundlePrimaryIcon =         {
     CFBundleIconFiles =             (
     AppIcon29x29,
     AppIcon40x40,
     AppIcon57x57,
     AppIcon60x60,
     AppIcon120x120
     );
     };
     };
     */
    
    NSArray *arrIcons = [[NSBundle mainBundle] infoDictionary][ @"CFBundleIcons" ][ @"CFBundlePrimaryIcon" ][ @"CFBundleIconFiles" ];
    UIImage *appIcon = nil;
    NSUInteger uiIconCount = [arrIcons count];
    for (NSInteger i = uiIconCount - 1; i >= 0; i -- ) {
        appIcon = [UIImage imageNamed:arrIcons[ i ]];
        if (appIcon) {
            break;
        }
    }
    
    _m_viewAvatarImage.image = appIcon;
    appNameLabel.text = IBT_APP_NAME_STR;
    
    // Section 0
    IBTTableViewSectionInfo *sec0Info = [IBTTableViewSectionInfo sectionInfoDefaut];
    
    // Version
#if DEBUG
    NSString *nsBuild = IBT_APP_BUILD_STR;
    NSString *nsVersion = IBT_APP_VERSION_STR;
    NSString *nsV = (nsBuild.length > 0) ? [NSString stringWithFormat:@"%@(%@)", nsVersion, nsBuild] : nsVersion;
#else
    NSString *nsV = IBT_APP_VERSION_STR;
#endif
    
    IBTTableViewCellInfo *versionCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                    title:[IBTCommon localizableString:@"Version"]
                               rightValue:nsV
                            accessoryType:UITableViewCellAccessoryNone];
    versionCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [sec0Info addCell:versionCellInfo];
    
    IBTTableViewCellInfo *phoneCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                     title:[IBTCommon localizableString:@"Phone Number"]
                                rightValue:@"021－61535615"
                             accessoryType:UITableViewCellAccessoryNone];
    phoneCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [sec0Info addCell:phoneCellInfo];
    
    [_m_tableViewInfo addSection:sec0Info];
}

@end
