//
//  BaseAlertCardViewController.m
//  patrol
//
//  Created by Javen on 2017/3/3.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseAlertCardViewController.h"

static NSInteger const shadowTag = 1111;
@interface BaseAlertCardViewController ()<UIGestureRecognizerDelegate>

@end

@implementation BaseAlertCardViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.alertCard.transform = CGAffineTransformMakeScale(0.1, 0.1);
    self.view.backgroundColor = [UIColor colorWithW:0.3 a:0];
    // Do any additional setup after loading the view.
    self.view.tag = shadowTag;
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(actionTap:)];
    UIView *tapView = [[UIView alloc] initWithFrame:self.view.bounds];
    tapView.backgroundColor = [UIColor colorWithW:0.01 a:0.01];
    [self.view insertSubview:tapView belowSubview:self.alertCard];
    [tapView addGestureRecognizer:tap];
}

- (void)actionTap:(UITapGestureRecognizer *)tap {
        [self hide];
}

- (IBAction)actionHide:(id)sender {
    [self hide];
}

- (void)setSuperVC:(UIViewController *)superVC {
    _superVC = superVC;
    
    [superVC addChildViewController:self];
}

/**
 显示整个确认框
 */
- (void)show {
    self.view.frame = self.superVC.view.bounds;
    
    [self.superVC.view addSubview:self.view];
    
    [UIView animateWithDuration:0.5
                          delay:0
         usingSpringWithDamping:0.7
          initialSpringVelocity:1.0
                        options:UIViewAnimationOptionCurveEaseOut
                     animations:^{
                         self.view.backgroundColor = [UIColor colorWithW:0.3 a:0.5];
                         self.alertCard.transform = CGAffineTransformMakeScale(1, 1);
                     }
                     completion:nil];
}


/**
 隐藏整个确认框
 */
- (void)hide {
    [UIView animateWithDuration:0.5
                          delay:0
         usingSpringWithDamping:0.9
          initialSpringVelocity:1.0
                        options:UIViewAnimationOptionCurveEaseOut
                     animations:^{
                         self.view.backgroundColor = [UIColor colorWithW:0.3 a:0.0];
                         self.alertCard.transform = CGAffineTransformMakeScale(0.01, 0.01);
                     }
                     completion:^(BOOL finished) {
                         [self.view removeFromSuperview];
                     }];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
