//
//  FilterDetailViewController.h
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "BaseViewController.h"
#import "FilterSearchModel.h"

@interface FilterDetailViewController : BaseViewController



/**
 默认筛选项详情
 */
@property (weak, nonatomic) IBOutlet UITableView *filterDetailTableView;

/**
 筛选项详情搜索
 */
@property (weak, nonatomic) IBOutlet UISearchBar *filterSearchBar;

/**
 筛选数据
 */
@property (nonatomic, strong) NSArray<FilterSearchModel *> *filterArray;

/**
 筛选条件  NSIndexPath
 */
@property (nonatomic, strong) NSIndexPath *conditionIndexPath;

/**
 确认筛选项回调
 */
@property (nonatomic, copy) void(^sureButtonBlock)(NSIndexPath *indexPath,FilterSearchModel *model,NSIndexPath *conditionIndexPath);

/**
 点击选项回调
 */
@property (nonatomic, copy) void(^selectedItemBlock)(NSIndexPath *indexPath,FilterSearchModel *model);

/**
 是否被包裹在别的控制器
 */
@property (nonatomic, assign) BOOL isContentVc;

@end
