
//
//  GTOCommonTools.m
//  total
//
//  Created by freecui on 15/10/15.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOCommonTools.h"

@implementation GTOCommonTools

#pragma mark - Class Method
+ (instancetype)sharedManager {
    static GTOCommonTools *_tool = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _tool = [[[self class] alloc] init];
    });
    
    return _tool;
}
//null 转@“”
+ (NSString *)nullChangedWithId: (id)data {
    if ([data isKindOfClass:[NSNull class]] || !data) {
        return @"";
    } else {
        return data;
    }
}
+ (NSString *)stringWithId:(id)data {
    if (!data || [data isEqual:[NSNull null]]) {
        return @"";
    }
    return [NSString stringWithFormat:@"%@",data];
}
+ (NSDate *)dateWithString:(NSString *)string {
    
    NSDateFormatter* dateFormat = [[NSDateFormatter alloc] init];
    [dateFormat setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSDate *date = [dateFormat dateFromString:string];
    
    return date;
}

#pragma mark -只精确到年月日
+ (NSDate *)dateTwoWithString:(NSString *)string {
    NSDateFormatter* dateFormat = [[NSDateFormatter alloc] init];
    [dateFormat setDateFormat:@"yyyy-MM-dd"];
    NSDate *date = [dateFormat dateFromString:string];
    
    return date;
}


+ (NSString *)stringLetterWithNumber: (NSInteger)number {//数字对应字母
    char c = (char)(65+number);
    return [NSString stringWithFormat:@"%c",c];
}
+ (NSString *)dateSubstringDeleteZeroWithDateString:(NSString *)string {
    
    if ([string containsString:@"+"]) {
        NSUInteger index = [string rangeOfString:@"+"].location;
        return [string substringToIndex:index];
    }
    return string;
}

//拓站状态
+ (NSString *)pioneeringStateWithString: (NSString *)state{
    if ([state isEqualToString:GTO_PIONEERING_STATE_INITIAL]) {
        return @"未提交";
    } else if ([state isEqualToString:GTO_PIONEERING_STATE_SUBMITTED]) {
        return @"已提交";
    } else {
        return @"没有此状态";
    }
}

//VI检查
+ (NSString *)pioneeringCategoryWithString: (NSString *)category {
    if ([category isEqualToString:@"project"]) {
        return @"工程VI检查列表";
    } else if ([category isEqualToString:@"HSE"]) {
        return @"HSEVI检查列表";
    } else {
        return @"error";
    }
}

//各种VI检查和SHE状态返回成对应的中文
+ (NSString *)patrolStateChineseWithEnglish: (NSString *)englishState {
    if ([englishState isEqualToString:GTO_PATROL_STATE_INITIAL]) {
        return @"未提交";
    } else if ([englishState isEqualToString:GTO_PATROL_STATE_SUBMITTED]) {
        return @"已提交";
    }else if ([englishState isEqualToString:GTO_PATROL_STATE_PROCESSING]) {
        return @"执行中";
    }else if ([englishState isEqualToString:GTO_PATROL_STATE_FINISHED]) {
        return @"已完成";
    }else if ([englishState isEqualToString:GTO_PATROL_STATE_CANCLED]) {
        return @"已取消";
    }else  {
        return @"无此状态";
    }

}
//各种许可证状态返回成对应的中文
+ (NSString *)licenceStateChineseWithEnglish: (NSString *)englishState {
    if ([englishState isEqualToString:@"initial"]) {
        return @"未提交";
    } else if ([englishState isEqualToString:@"submitted"]) {
        return @"申请审批";
    }else if ([englishState isEqualToString:GTO_LICENCE__STATE_ASKFORAPPROVE]) {
        return @"待审批";
    }else if ([englishState isEqualToString:@"approved"]) {
        return @"审批通过";
    }else if ([englishState isEqualToString:@"rejected"]) {
        return @"审批拒绝";
    }else if ([englishState isEqualToString:@"expired"]) {
        return @"已过期";
    }else if ([englishState isEqualToString:@"finished"]) {
        return @"已结束";
    }else  {
        return @"无此状态";
    }

}
//各种报修状态返回成对应的中文
+ (NSString *)repairStateChineseWithEnglish: (NSString *)englishState {
    if ([englishState isEqualToString:@"initial"]) {
        return @"未提交";
    } else if ([englishState isEqualToString:@"submitted"]) {
        return @"待处理";
    }else if ([englishState isEqualToString:@"processing"]) {
        return @"处理中";
    }else if ([englishState isEqualToString:@"application"]) {
        return @"已申请";
    }else if ([englishState isEqualToString:@"finished"]) {
        return @"已结束";
    }else  {
        return @"无此状态";
    }
    
}
//各种拓站状态返回成对应的中文
+ (NSString *)pioneeringStateChineseWithEnglish: (NSString *)englishState {
    if ([englishState isEqualToString:@"initial"]) {
        return @"未提交";
    } else if ([englishState isEqualToString:@"submitted"]) {
        return @"已完成";
    }else  {
        return @"无此状态";
    }
    
}

//根据状态返回返回不同的文字颜色
+ (UIColor *)textColorWithState: (NSString *)state {
    if ([state isEqualToString:@"initial"]) { //未提交
        return GTO_RED_COLOR;
    } else if ([state isEqualToString:@"submitted"]) { //申请审批（和待审批的英文单词互换）
        return GTO_BLUE_SHALLOW_TINT_COLOR;
    }else if ([state isEqualToString:@"approved"]) {
        return GTO_GREEN_COLOR;
    }else if ([state isEqualToString:@"rejected"]) {
        return GTO_RED_COLOR;
    }else if ([state isEqualToString:@"expired"]) {
        return GTO_GRAY_SHALLOW_TINT_COLOR;
    }else if ([state isEqualToString:@"finished"]) {
        return GTO_GRAY_SHALLOW_TINT_COLOR;
    }else if ([state isEqualToString:@"application"]) {
        return GTO_GREEN_COLOR;
    }else if ([state isEqualToString:@"processing"]) {
        return GTO_BLUE_SHALLOW_TINT_COLOR;
    }else  if([state isEqualToString:@"askforapprove"]){ //待审批
        return GTO_BLUE_SHALLOW_TINT_COLOR;
    }else{
        return nil;
    }
}

+ (UIColor *)textColorWithRepairState: (NSString *)state
{
    if ([state isEqualToString:@"initial"]) {
        return GTO_RED_COLOR;
    } else if ([state isEqualToString:@"submitted"]) {
        return GTO_RED_COLOR;
    }else if ([state isEqualToString:@"approved"]) {
        return GTO_GREEN_COLOR;
    }else if ([state isEqualToString:@"rejected"]) {
        return GXF_ORIGIN_COLOR;
    }else if ([state isEqualToString:@"expired"]) {
        return GTO_GRAY_SHALLOW_TINT_COLOR;
    }else if ([state isEqualToString:@"finished"]) {
        return GTO_GRAY_SHALLOW_TINT_COLOR;
    }else if ([state isEqualToString:@"application"]) {
        return GTO_GREEN_COLOR;
    }else if ([state isEqualToString:@"processing"]) {
        return GTO_BLUE_SHALLOW_TINT_COLOR;
    }else  {
        return nil;
    }

}

//是否有某个功能的权限
+ (BOOL)hasPermissionWithPermissionId: (NSUInteger)permissionId {
    BOOL hasPermission = NO;
    ICRUserUtil *userU = [ICRUserUtil sharedInstance];
    if (userU.f_permissions.count < 1)  return hasPermission;
    for(NSString *strPer in userU.f_permissions) {
        if ([strPer integerValue] == permissionId) {
            hasPermission = YES;
            break;
        }
    }
    return hasPermission;
}

//是否在一定时间范围内
+ (BOOL)nowInTimeDuringMinTime: (NSString *)minTime
                       maxTime: (NSString *)maxTime{
    NSTimeInterval nowInterl = [[NSDate date]timeIntervalSince1970];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc]init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];//时间格式要对应？？？？
    NSDate *minDate = [dateFormatter dateFromString:minTime];
    NSDate *maxDate = [dateFormatter dateFromString:maxTime];
    // NSDate *date = [dateFormatter dateFromString:@"2015-12-01"];
    
    NSTimeInterval minTimeInterl = [minDate timeIntervalSince1970];
    NSTimeInterval maxTimeInterl = [maxDate timeIntervalSince1970];
    if (nowInterl >= minTimeInterl && nowInterl <= maxTimeInterl) {
        return YES;
    } else {
        return NO;
    }
}


#pragma mark -返回订油单、配油单、建仓单、收油单图片
+ (UIImage *)returnOrderStateImage:(NSString *)stateString
{
    if ([stateString isEqualToString:@"initial"]) {//未提交
        return TCImage(@"组-9-副本");
    } else if ([stateString isEqualToString:@"submit"]) {//已提交
        return TCImage(@"组-9");
    } else if ([stateString isEqualToString:@"canceled"]) {//已作废
        return TCImage(@"组-9-副本-2");
    } else if ([stateString isEqualToString:@"accomplished"]) {//已完成
        return TCImage(@"complete");
    } else if ([stateString isEqualToString:@"shipping"]) {//配送中
        return TCImage(@"distribution");
    } else if ([stateString isEqualToString:@"shipped"]) {//已配送
        return TCImage(@"已配送");
    } else if ([stateString isEqualToString:@"effectived"]) {//已生效
        return TCImage(@"已生效");
    } else if ([stateString isEqualToString:@"delete"]) {//已删除
        return TCImage(@"deleteorder");
    } else if ([stateString isEqualToString:@"cancel"]) {//已作废
        return TCImage(@"组-9-副本-2");
    }
    
    return nil;
}

#pragma mark -返回文字
+ (NSString *)returnOrderStateString:(NSString *)stateString
{
    if ([stateString isEqualToString:@"initial"]) {//未提交
        return @"未提交";
    } else if ([stateString isEqualToString:@"submit"]) {//已提交
        return @"已提交";
    } else if ([stateString isEqualToString:@"canceled"]) {//已作废
        return @"已作废";
    } else if ([stateString isEqualToString:@"accomplished"]) {//已完成
        return @"已完成";
    } else if ([stateString isEqualToString:@"shipping"]) {//配送中
        return @"配送中";
    } else if ([stateString isEqualToString:@"shipped"]) {//已配送
        return @"已配送";
    } else if ([stateString isEqualToString:@"effectived"]) {//已生效
        return @"已生效";
    }else if ([stateString isEqualToString:@"delete"]) {//已删除
        return @"已删除";
    } else if ([stateString isEqualToString:@"cancel"]) {//已作废
        return @"已作废";
    }
    return nil;
}

#pragma amrk -返回相应状态文字颜色
+ (UIColor *)returnOrderSateColor:(NSString *)stateString
{
    if ([stateString isEqualToString:@"initial"]) {//未提交
        return RGBA(80, 209, 51, 1);
    } else if ([stateString isEqualToString:@"submit"]) {//已提交
        return RGBA(223, 6, 12, 1);
    } else if ([stateString isEqualToString:@"canceled"]) {//已作废
        return RGBA(124, 135, 136, 1);
    } else if ([stateString isEqualToString:@"accomplished"]) {//已完成
        return RGBA(84, 140, 201, 1);
    } else if ([stateString isEqualToString:@"shipped"]) {//已配送
        return RGBA(246, 215, 69, 1);
    } else if ([stateString isEqualToString:@"shipping"]) {//配送中
        return RGBA(255, 178, 80, 1);
    } else if ([stateString isEqualToString:@"effectived"]) {//已生效
        return RGBA(255, 178, 80, 1);
    }
    return nil;
}



#pragma mark -取消MJRfresh刷新状态
//结束MJRefresh刷新状态
+ (void)cancelMJRefreshState:(UIScrollView *)scrollView
{
    if ([scrollView.mj_header isRefreshing]) {
        [scrollView.mj_header endRefreshing];
    }
    if ([scrollView.mj_footer isRefreshing]) {
        [scrollView.mj_footer endRefreshing];
    }
}



#pragma mark -获取当前时间
+ (NSString *)GetCurrenttime
{
    NSDate *date = [[NSDate alloc] init];
    //获取一下当前的时区
    NSTimeZone *zone=[NSTimeZone timeZoneWithName:@"UTC"];
    //根据对应的时区,获取和0时区相差的秒数
    NSInteger seconds = [zone secondsFromGMTForDate:date];
    //获取当前的时间
    NSDate *localDate = [NSDate dateWithTimeIntervalSinceNow:seconds];
    NSDateFormatter *formatter = [[NSDateFormatter alloc]init];
    [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSString *datetime = [formatter stringFromDate:localDate];
    return datetime;
}


#pragma mark -计算两个字符串的和
+ (NSDecimalNumber *)calculateTwoStringAddingOneString:(NSString *)string stringTwo:(NSString *)stringtwo
{
    NSDecimalNumber *numberone = [NSDecimalNumber decimalNumberWithString:string];
    NSDecimalNumber *numbertwo = [NSDecimalNumber decimalNumberWithString:stringtwo];
    NSDecimalNumber *addingResult = [numberone decimalNumberByAdding:numbertwo];
    return addingResult;
}


#pragma mark -计算两个字符串的差
+ (NSDecimalNumber *)calculateTwoStringSubtractingOneString:(NSString *)string stringTwo:(NSString *)stringtwo
{
    NSDecimalNumber *numberone = [NSDecimalNumber decimalNumberWithString:string];
    NSDecimalNumber *numbertwo = [NSDecimalNumber decimalNumberWithString:stringtwo];
    NSDecimalNumber *subtractingResult = [numberone decimalNumberBySubtracting:numbertwo];
    return subtractingResult;
}


#pragma mark -计算两个字符串的积
+ (NSDecimalNumber *)calculateTwoStringMultiplyingOneString:(NSString *)string stringTwo:(NSString *)stringtwo
{
    NSDecimalNumber *numberone = [NSDecimalNumber decimalNumberWithString:string];
    NSDecimalNumber *numbertwo = [NSDecimalNumber decimalNumberWithString:stringtwo];
    NSDecimalNumber *MultiplyingResult = [numberone decimalNumberByMultiplyingBy:numbertwo];
    return MultiplyingResult;
}

#pragma mark -计算两个字符串的商
+ (NSDecimalNumber *)calculateTwoStringDividingOneString:(NSString *)string stringTwo:(NSString *)stringtwo
{
    NSDecimalNumber *numberone = [NSDecimalNumber decimalNumberWithString:string];
    NSDecimalNumber *numbertwo = [NSDecimalNumber decimalNumberWithString:stringtwo];
    NSDecimalNumber *DividingResult = [numbertwo decimalNumberByDividingBy:numberone];
    return DividingResult;
}

@end
