//
//  ICRUserUtil.h
//  Cruiser
//  手机app登陆者
//  Created by Xummer on 3/29/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "AccountConfigModel.h"


@interface ICRUserUtil : IBTObject <NSCoding, NSCopying> //归档存储


@property (copy, nonatomic) NSString *f_user_password;
@property (copy, nonatomic) NSString *f_user_loginName;//登录时填写的名称
@property (copy, nonatomic) NSString *f_user_code;//用户代码
@property (copy, nonatomic) NSString *f_user_name;//用户名称
@property (copy, nonatomic) NSString *f_user_uuid;//唯一标识

@property (copy, nonatomic) NSString *f_authenticode;//企业认证码
@property (copy, nonatomic) NSString *f_enterprise_code;//企业代码
@property (copy, nonatomic) NSString *f_enterprise_name;//企业名称
@property (copy, nonatomic) NSString *f_enterprise_uuid;//唯一标识
@property (nonatomic,strong) NSArray *storeArray;//登陆人的油站列表

@property (copy, nonatomic) NSArray *f_permissions;//权限列表
@property (copy, nonatomic) NSString *f_city;//百度地图定位的城市
@property (assign, nonatomic) BOOL f_isLogout;

@property (assign, nonatomic) BOOL hasAffichePermission;
@property (assign, nonatomic) BOOL hasProjectPatrolPermission;
@property (assign, nonatomic) BOOL hasHSEPatrolPermission;
@property (assign, nonatomic) BOOL hasLicencePermission;

//@property (assign,nonatomic)BOOL needFresh;

// Login Data
@property (copy, nonatomic) NSString *userName;
@property (copy, nonatomic) NSString *password;
@property (copy, nonatomic) NSString *registerCode;
@property (copy, nonatomic) NSString *token;
@property (copy, nonatomic) NSNumber *bAutoLogin;

// User Data
@property (copy, nonatomic) NSString *displayName;
@property (copy, nonatomic) NSString *orgCode;//所属公司code
@property (copy, nonatomic) NSString *orgName;//所属公司name
@property (copy, nonatomic) NSString *orguuid;//所属公司uuid
@property (nonatomic,copy) NSString *position;//职位
@property (copy, nonatomic) NSNumber *currentStoreID;
@property (copy, nonatomic) NSString *uniqueID;
//经纬度信息
@property (nonatomic, copy) NSString *latitude;
@property (nonatomic, copy) NSString *longitude;
//配置项
@property (nonatomic, strong) AccountConfigModel *configModel;
/**
 地图类型
 */
@property (nonatomic, assign) MapType map_Type;
/**
 无权限时菜单是否显示
 */
@property (nonatomic, assign) BOOL appAuthorityLock;

+ (instancetype)sharedInstance;

- (BOOL)saveArchive;

- (BOOL)isLogin;

- (void)logout;

- (NSString *)mobileID;

- (void)storageUserName:(NSString *)userName
               password:(NSString *)password
           registerCode:(NSString *)registerCode
                  token:(NSString *)token;

- (void)storageCurrentStoreID:(NSNumber *)currentStoreID;

- (void)updatePassword:(NSString *)pwd;

@end
