//
//  ImageTool.m
//  besttoneMobile
//
//  Created by Besttone on 16/12/6.
//  Copyright © 2016年 Besttone. All rights reserved.
//

#import "ImageTool.h"
#import <UIKit/UIKit.h>
@implementation ImageTool
//对图片大小进行压缩至32K以下
+ (NSData *)zipImageWithUrl:(id)imageUrl
{
    NSURL * url = [NSURL URLWithString:imageUrl];
    
    if (url == nil){
        url = [NSURL URLWithString:[imageUrl stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
    }
    
    NSData * imageData = [[NSData alloc]initWithContentsOfURL:url];
    
    CGFloat maxFileSize = 32*1024;
    
    CGFloat compression = 0.9f;
    
    CGFloat maxCompression = 0.1f;
    
    UIImage *image = [UIImage imageWithData:imageData];
    
    NSData *compressedData = UIImageJPEGRepresentation(image, compression);
    
    while ([compressedData length] > maxFileSize && compression > maxCompression) {
        compression -= 0.1;
        compressedData = UIImageJPEGRepresentation(image, compression);
    }
    return compressedData;
}
+ (NSData *)zipImageWithUrl:(id)imageUrl maxSize:(CGFloat)size{
    NSURL * url = [NSURL URLWithString:imageUrl];
    
    if (url == nil){
        url = [NSURL URLWithString:[imageUrl stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
    }
    
    NSData * data = [[NSData alloc]initWithContentsOfURL:url];
    UIImage *resultImage = [[UIImage alloc]initWithData:data];
    NSUInteger lastDataLength = 0;
    while (data.length > size && data.length != lastDataLength) {
        lastDataLength = data.length;
        CGFloat ratio = size / data.length;
        CGSize size = CGSizeMake((NSUInteger)(resultImage.size.width * sqrtf(ratio)),
                                 (NSUInteger)(resultImage.size.height * sqrtf(ratio)));
        UIGraphicsBeginImageContext(size);
        [resultImage drawInRect:CGRectMake(0, 0, size.width, size.height)];
        resultImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        data = UIImageJPEGRepresentation(resultImage, 1);
    }
    return data;
}
+ (NSData *)zipImageWithImage:(UIImage *)image maxSize:(CGFloat)size{
    
    UIImage *resultImage = image;
    NSUInteger lastDataLength = 0;
    
    CGFloat compression = 0.8f;
    CGFloat maxCompression = 0.2f;
    
    NSData *compressedData = UIImageJPEGRepresentation(image, compression);
    while ([compressedData length] > size && compression > maxCompression) {
        compression -= 0.1;
        compressedData = UIImageJPEGRepresentation(image, compression);
    }
    
    while (compressedData.length > size && compressedData.length != lastDataLength) {
        lastDataLength = compressedData.length;
        CGFloat ratio = size / compressedData.length;
        CGSize size = CGSizeMake((NSUInteger)(resultImage.size.width * sqrtf(ratio)),
                                 (NSUInteger)(resultImage.size.height * sqrtf(ratio)));
        UIGraphicsBeginImageContext(size);
        [resultImage drawInRect:CGRectMake(0, 0, size.width, size.height)];
        resultImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        compressedData = UIImageJPEGRepresentation(resultImage, 0.8);
    }
    
    return compressedData;
}
+ (CGFloat)getImageSize:(UIImage *)image{
    NSData * compressedData = UIImageJPEGRepresentation(image, 1);
    return [compressedData length];
}
+ (UIImage *)imageWithUrl:(id)imageUrl{
    NSURL * url = [NSURL URLWithString:imageUrl];
    
    if (url == nil){
        url = [NSURL URLWithString:[imageUrl stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
    }
    NSData * imageData = [[NSData alloc]initWithContentsOfURL:url];
    return [UIImage imageWithData:imageData];
}

+ (UIImage *)zipImageBackImageWithImage:(UIImage *)image maxSize:(CGFloat)size{
    UIImage *resultImage = image;
    NSUInteger lastDataLength = 0;
    
    CGFloat compression = 0.8f;
    CGFloat maxCompression = 0.2f;
    
    NSData *compressedData = UIImageJPEGRepresentation(image, compression);
    while ([compressedData length] > size && compression > maxCompression) {
        compression -= 0.1;
        compressedData = UIImageJPEGRepresentation(image, compression);
    }
    
    while (compressedData.length > size && compressedData.length != lastDataLength) {
        lastDataLength = compressedData.length;
        CGFloat ratio = size / compressedData.length;
        CGSize size = CGSizeMake((NSUInteger)(resultImage.size.width * sqrtf(ratio)),
                                 (NSUInteger)(resultImage.size.height * sqrtf(ratio)));
        UIGraphicsBeginImageContext(size);
        [resultImage drawInRect:CGRectMake(0, 0, size.width, size.height)];
        resultImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
    }
    return resultImage;
}

@end



















