//
//  RequestManager.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/28.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "RequestManager.h"
@implementation RequestManager


/**
 获取服务器时间
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_SystemTimeSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] GET:[ToolsManager completeUrl:SYSTIME] withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取App配置项
 
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_OptionSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSDictionary *parmeter = @{@"enterprise":kUser.f_enterprise_uuid};
    [[NetWorkRequestManager shareManager] GET:[ToolsManager completeUrl:UPLOADCONFIG] withParmeter:parmeter success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取自检匹配门店坐标级别
 
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_StoreCoordinatesLevelSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSDictionary *parmeter = @{@"enterprise":kUser.f_enterprise_uuid};
    [[NetWorkRequestManager shareManager] GET:[ToolsManager completeUrl:STORECOORDLEVEL] withParmeter:parmeter success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
获取待办(首页)

@param success 成功回调
@param failure 失败回调
*/
+ (void)request_TodoSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [[ToolsManager completeUrl:TODO] stringByAppendingFormat:@"/%@",kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
自检以及VI检查的进度(首页)

@param success 成功回调
@param failure 失败回调
*/
+ (void)request_PatrolAndInspectionSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [[ToolsManager completeUrl:PRAISEANDINSPECTOR_PROGRESS] stringByAppendingFormat:@"/%@",kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
督导的营运指数数据(首页)

@param success 成功回调
@param failure 失败回调
*/
+ (void)request_SupervisorServiceSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [[ToolsManager completeUrl:SUPERVISOR_SERVICE] stringByAppendingFormat:@"/%@",kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取当日自检进度（首页）
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_InspectionProgress:(NSString *)date success:(SuccessBlock)success failure:(ErrorBlock)failure
{

    NSDictionary *parameters = @{@"userUuid":kUser.f_user_uuid,@"dateEquals":date,@"pageNumber":@(0),@"pageSize":@(1)};
    [[NetWorkRequestManager shareManager] POST:[ToolsManager completeUrl:QUERYPRAISESBYDAY] withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取当日自检任务、时间轴（首页）
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_Inspection:(NSString *)date success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:QUERYPRAISESBYDAY2],date,kUser.orguuid];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取门店营运数据（首页）
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_StoreServiceSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:STORESERVICE],kUser.orgCode];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 根据门店坐标获取门店名称、code
 
 @param longitude 经度
 @param latitude  纬度
 @param success   成功回调
 @param failure   失败回调
 */
+ (void)request_StoreInformation:(NSString *)longitude latitude:(NSString *)latitude success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:STORECOORD],kUser.f_user_uuid,longitude,latitude];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 根据自检任务详情
 
 @param questionUuid 自检问题Uuid
 @param answerUuid   自检答案Uuid
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_InspectDetail:(NSString *)questionUuid answerUuid:(NSString *)answerUuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:INSPECTDETAIL],questionUuid,answerUuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 上传自检结果
 
 @param taskUuid     自检详情Uuid
 @param parmeter     参数
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_UploadInspectResult:(NSString *)taskUuid parmeter:(NSDictionary *)parmeter success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:UPLOADINSPECTRESULT],taskUuid,[[NSDate date] httpParameterString],kUser.f_user_code,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parmeter success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取VI检查任务图片
 
 @param attachmentId 附件Uuid
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolInspectAttachment:(NSString *)attachmentId success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:PATROLINSPECTATTACHMENT],attachmentId];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 通过状态获取公告列表

 @param type         公告类型
 @param pageNumber   当前页
 @param pageSize     每页个数
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_AnnouncementList:(NSInteger)type pageNumber:(NSInteger)pageNumber pageSize:(NSInteger)pageSize success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *typeStr;
    if (type) {
        typeStr = @"true";
    } else {
        typeStr = @"false";
    }
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETANNOUNCEMENT],kUser.f_user_uuid,typeStr,pageNumber,pageSize];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 通过id获取公告详情
 
 @param uuid         公告id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_AnnouncementDetail:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETANNOUNCEMENTDETAIL],uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 通过id标记公告状态
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_ChangeAnnouncementState:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:READANNOUNCEMENT],uuid,kUser.f_user_uuid,[[NSDate date] httpParameterString]];
    [[NetWorkRequestManager shareManager] POST:[ToolsManager returnUrlString:urlString] withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**********************************筛选条件***********************************/
/**
 获取区域信息
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_Area_Success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [ToolsManager completeUrl:QUERYAREA];
    NSDictionary *parameters = @{
                                 @"pageNumber":@(0),
                                 @"pageSize":@(0),
                                 @"isLeaf":@NO,
                                 @"level":@2,
                                 };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取门店信息
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_Store_Success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYSTORE];
    NSDictionary *parameters = @{
                                 @"userUuid":kUser.f_user_uuid,
                                 @"pageNumber":@(0),
                                 @"isLeaf":@YES,
                                 @"pageSize":@(0)
                                 };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取门店类型
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_StoreType_Success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [ToolsManager completeUrl:QUERYSTORETYPE];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取门店人员
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_StoreUsers_Success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [ToolsManager completeUrl:QUERYSUPERVISOR];
    NSDictionary *parameters = @{
                                 @"pageNumber":@(0),
                                 @"pageSize":@(0),
                                 @"enabled": @YES,
                                 };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取督导人员
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_Supervisor_Success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYSUPERVISOR];
    NSDictionary *parameters = @{
                                 @"pageNumber":@(0),
                                 @"pageSize":@(0),
                                 @"enabled": @YES,
                                 @"position": @"inspector"
                                 };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取自检任务
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_InspectTask_Success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [ToolsManager completeUrl:QUERYTASK];
    NSArray *myArray = @[@{@"field" : @"beginHour",
                           @"direction" : @"asc"}];
    NSDictionary *parameters = @{
                                 @"pageNumber":@(0),
                                 @"pageSize":@(0),
                                 @"queryOrders":myArray,
                                 @"sourcePraise":@"-",
                                 @"states":@"submitted,reported,finished,processing,published"
                                 };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取自检检查项
 
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_InspectCheckItemByPraiseUuid:(NSString *)praiseUuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [ToolsManager completeUrl:QUERYCHECKITEM];
    NSDictionary *parameters = @{
                   @"pageNumber":@(0),
                   @"pageSize":@(0),
                   @"sourcePraise":@"-",
                   @"praiseUuid":praiseUuid ?: [NSNull null]
                   };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}
/**********************************筛选条件***********************************/

/**
 获取VI检查任务
 @param queryModel   查询
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolPlan:(ParametersModel *)queryModel success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYPATROLPLAN];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:[queryModel toDictionary] success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取VI检查任务详情
 @param planUuid     VI检查任务id
 @param storeUuid    门店id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolPlanDetail:(NSString *)planUuid storeUuid:(NSString *)storeUuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
     NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYPATROLPLANDETAIL],planUuid,storeUuid,kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取VI检查任务结果详情
 @param planUuid     VI检查任务id
 @param storeUuid    门店id
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_PatrolPlanResult:(NSString *)planUuid storeUuid:(NSString *)storeUuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYPATROLINSPECTDETAIL],planUuid,storeUuid,kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 提交VI检查任务
 @param planUuid     VI检查任务id
 @param type         保存、提交
 @param parameter    参数
 @param success      成功回调
 @param failure      失败回调
 */
+ (void)request_SubmitPatrolPlan:(NSString *)planUuid type:(NSString *)type parameter:(NSDictionary *)parameter success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,SUBMITPATROLPLAN],type,planUuid];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameter success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 VI检查任务开始答题
 
 @param planUuid            VI检查任务uuid
 @param storeUuid           门店uuid
 @param selectedStoreUuid   选择门店uuid
 @param longtitude          经度
 @param latitute            纬度
 @param success             成功回调
 @param failure             失败回调
 */
+ (void)request_BeginPatrolPlanAnswer:(NSString *)planUuid storeUuid:(NSString *)storeUuid selectedStoreUuid:(NSString *)selectedStoreUuid longtitude:(NSString *)longtitude latitute:(NSString *)latitute success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,BEGINPATROLPLANANSWER],planUuid,storeUuid,kUser.f_user_uuid,selectedStoreUuid,longtitude,latitute];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取周围门店
 
 @param longtitude          经度
 @param latitute            纬度
 @param success             成功回调
 @param failure             失败回调
 */
+ (void)request_QueryRoundStoreLongtitude:(NSString *)longtitude latitute:(NSString *)latitute success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:QUERYROUNDSTORE],longtitude,latitute];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 VI检查结果查看
 
 @param model            ParametersModel
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryPatrolInspectResult:(ParametersModel *)model success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYPATROLINSPECTRESULT];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:[model toDictionary] success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 VI检查任务列表
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryPatrolInspectResultSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYPATROLINSPECTPLAN],kUser.f_user_uuid,[[NSDate date] httpParameterString],@"0",@"0"];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 VI检查任务附件查询
 
 @param entityUuid       附件id
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryPatrolPlanAttachments:(NSString *)entityUuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,QUERYPATROLATTACHMENT],entityUuid];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 生成VI抽查

 @param store_Uuid 油站ID
 @param success    成功回调
 @param failure    失败回调
 */
+ (void)request_CreatePatrolTempCheck:(NSString *)store_Uuid success:(SuccessBlock)success failure:(ErrorBlock)failure {
    NSString *urlString = [NSString stringWithFormat:[NSString stringWithFormat:@"%@/%@",VIHTTP_REST_API_BASE_URL,CREATEVITEMPCHECK],kUser.f_user_uuid,store_Uuid];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}



/**
 自检结果发表评论
 
 @param attachmentUuid   自检结果附件uuid
 @param comment          评论内容
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_InspectResultPostComment:(NSString *)attachmentUuid comment:(NSString *)comment success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:INSPECTSUBMITCOMMENT],[[NSDate date] httpParameterString],kUser.f_user_code,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    NSDictionary *parameters = @{ @"entityType" : @"attachment",
                                  @"entityUuid" : attachmentUuid,
                                  @"comment" : comment };
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:parameters success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取最近一次签到信息
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetLastSignInSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETLASESIGNIN],kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 通过坐标获取一定范围内门店
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetStoresByCoord:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETSTORESBYCOORD],kUser.f_user_uuid,kUser.longitude,kUser.latitude];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 版本更新
 
 @param success 成功回调
 @param failure 失败回调
 */
+ (void)request_UpdateVersionSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] GET:[ToolsManager completeUrl:UPDATEVERSION] withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 获取报修设备
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetRepairsEquipmentSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] POST:[ToolsManager completeUrl:GETDEVICES] withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 通过二维码获取报修设备
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetRepairsEquipmentByQRCode:(NSString *)QRCode success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETDEVICESBYQRCODE],QRCode];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 获取报修类型
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetRepairsTypeSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] GET:[ToolsManager completeUrl:GETREPATRSTYPE] withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 提交设备报修单
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_SubmitRepairsTask:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:SUBMITREPAIRS],[[NSDate date] httpParameterString],kUser.f_user_uuid,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 查询设备报修单
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryRepairsBill:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] POST:[ToolsManager completeUrl:QUERYREPAIR] withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 设备报修保存过程记录
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_RepairsSaveLog:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:SAVEREPAIRLOG],[[NSDate date] httpParameterString],kUser.f_user_uuid,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 设备报修删除过程记录
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_RepairsDeleteLog:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:DELETEREPAIRLOG],uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 设备报修保存费用说明
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_RepairsSaveFee:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:SAVEREPATRFEE],[[NSDate date] httpParameterString],kUser.f_user_uuid,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 设备报修删除费用说明
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_RepairsDeleteFee:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:DELETEREPATRFEE],uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 查询设备报修单详情
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryRepairsBillDetail:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:QUERYREPAIRDETAIL],uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 查询营运指数
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QuerySchoolInfoSuccess:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] GET:[ToolsManager completeUrl:OPERATIONGRATIOS] withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 查询优秀案例
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QueryGoodCase:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    [[NetWorkRequestManager shareManager] POST:[ToolsManager completeUrl:QUERYGOODCASE] withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 优秀案例点赞
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GoodCaseLike:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:LIKEGOODCASE],uuid,[[NSDate date] httpParameterString],kUser.f_user_code,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 优秀案例取消点赞
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GoodCaseCancelLike:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:CANCELLIKEGOODCASE],uuid,[[NSDate date] httpParameterString],kUser.f_user_code,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 优秀案例详情
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetGoodCaseDetail:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETGOODCASEDETAIL],uuid,kUser.f_user_uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 陈列管理查询
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetStoreLayout:(NSString *)code success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:QUERYSTORELAYOUT],code];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 陈列管理获取附件
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_GetStoreLayouAttachment:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETATTACHMENT],uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 通过Uuid删除待办任务
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_RemoveTodoTask:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:REMOVETODOTASK],uuid];
    [[NetWorkRequestManager shareManager] GET:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}


/**
 提交销售录入
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_SubmitSaleInput:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:SUBMITSALEINPUT],[[NSDate date] httpParameterString],kUser.f_user_code,kUser.f_user_name];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 工作汇报标记已读
 
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_WorkReportRead:(NSString *)uuid success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:READWORKREPORT],uuid,kUser.f_user_uuid,[[NSDate date] httpParameterString]];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:nil success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}

/**
 查询签到统计
 
 @param viewOrgUuid      viewOrgUuid
 @param params           参数
 @param success          成功回调
 @param failure          失败回调
 */
+ (void)request_QuerySignInStatistical:(NSString *)viewOrgUuid params:(NSDictionary *)params success:(SuccessBlock)success failure:(ErrorBlock)failure
{
    NSString *urlString = [NSString stringWithFormat:[ToolsManager completeUrl:GETSIGNSTATISTICAL],viewOrgUuid];
    urlString = [ToolsManager returnUrlString:urlString];
    [[NetWorkRequestManager shareManager] POST:urlString withParmeter:params success:^(id returnValue) {
        success(returnValue);
    } failure:^(id errorValue) {
        failure(errorValue);
    }];
}













                           
@end
