//
//  OSSHelper.h
//  patrol
//
//  Created by 曹云霄 on 16/8/23.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//
#import <Foundation/Foundation.h>
#import <AliyunOSSiOS/OSSService.h>


/**
 *  操作类型
 */
typedef NS_ENUM(NSInteger,OSSHelperOperationType) {
    /**
     *  异步
     */
    OSSHelperOperationTypeAsynchronous,
    /**
     *  同步
     */
     OSSHelperOperationTypeSynchronous
};


@interface OSSHelper : NSObject

/**
 *  上传文件
 *
 *  @param objectKey Key
 *  @param data      Data
 *  @param type      同步、异步
 *  @param progress  上传进度
 *  @param success   返回
 */
+ (void)uploadFileObjectWithKey:(NSString *)objectKey data:(NSData *)data type:(OSSHelperOperationType)type progress:(void (^)(double progress))progress success:(void (^)(OSSTask *task))success error:(void(^)(NSError *error))error;


/**
 *  下载附件
 *
 *  @param ObjectKey OSSkey
 *  @param type      同步、异步
 *  @param progress  进度
 *  @param success   成功回调
 */
+ (void)downloadObject:(NSString *)ObjectKey type:(OSSHelperOperationType)type progress:(void (^)(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend))progress success:(id (^)(OSSTask *task))success error:(void(^)(NSError *error))error;



/**
 *  获取唯一的文件名
 *
 *  @param type 区分图片还是视频<image/video>
 *
 *  @return NSString
 */

+ (NSString *)getOSSObjectKeyWithtype:(NSString *)type;

/**
 *  获取唯一的文件名
 *
 *  @param type  区分图片还是视频<image/video>
 *  @param index 多个时用过index来区分
 *
 *  @return NSString
 */
+ (NSString *)getOSSObjectKeyWithtype:(NSString *)type index:(NSInteger)index;


/**
 *  获得完整的图片路径
 *
 *  @param OSSKey OSSKey
 *
 *  @return 路径
 */
+ (NSString *)getCompleteImageURLWithOSSkey:(NSString *)OSSKey;

/**
 *  获得完整的视频路径
 *
 *  @param OSSKey OSSKey
 *
 *  @return 路径
 */
+ (NSString *)getCompleteVideoURLWithOSSkey:(NSString *)OSSKey;








@end
