//
//  PicViewModel.h
//  RealEstateManagement
//
//  Created by Javen on 2017/1/6.
//  Copyright © 2017年 上海勾芒信息科技. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, kPicCellType) {
    kPicCellTypeAdd = 0,
    kPicCellTypeEdit,
    kPicCellTypeRead
};


//图片的size
//允许的最大图片数量
//static CGFloat const kMaxAddRepairImgNumber = 4;

@interface PicViewModel : NSObject

/**
 允许的最大图片数量 默认是4
 */
@property (nonatomic, assign) CGFloat maxPictureNumber;


@property (strong, nonatomic) NSMutableArray *arrPics;
@property(nonatomic, strong) NSMutableArray *selectedAssets;

/**
 图片cell的类型
 */
@property (nonatomic, assign) kPicCellType type;

/**
 列数（一行显示几张照片） 默认是2
 */
@property (nonatomic, assign) NSInteger columns;


/**
 获取cell的高度

 @return 高度
 */
- (CGFloat)cellHeight;

/**
 获取图片行数

 @return 行数
 */
- (NSInteger)pictureRowNumbers;
@end
