//
//  PromptTableViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/23.
//  Copyright © 2016年 free. All rights reserved.
//

#import "PromptTableViewController.h"

@interface PromptTableViewController ()<DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 *  记录上一次选择的cell
 */
@property (nonatomic,strong) NSIndexPath *indexpathSelect;

/**
 *  记录选择的title
 */
@property (nonatomic,copy) NSString *selectTitle;

@end

@implementation PromptTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

- (void)uiConfigAction
{
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"cell"];
    //默认选中cell
    for (int i=0; i<self.datasArray.count; i++) {
        if ([self.currentTitle isEqualToString:self.datasArray[i]]) {
            self.indexpathSelect = [NSIndexPath indexPathForRow:i inSection:0];
        }
    }
    self.tableView.emptyDataSetSource = self;
    self.tableView.tableFooterView = [UIView new];
    //添加确定按钮
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(completeButtonClick:)];
}

#pragma mark - Table view data source
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return self.datasArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell" forIndexPath:indexPath];
    NSString *string = [self.datasArray objectAtIndex:indexPath.row];
    cell.textLabel.textColor = [self.selecteArray containsObject:string]?[UIColor grayColor]:[UIColor blackColor];
    cell.userInteractionEnabled = ![self.selecteArray containsObject:string];
    cell.textLabel.text = [self.datasArray objectAtIndex:indexPath.row];
    //根据记录的位置防止重用产生问题
    cell.accessoryType = (self.indexpathSelect == indexPath) ? UITableViewCellAccessoryCheckmark : UITableViewCellAccessoryNone;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    for (int i=0; i<self.datasArray.count; i++) {
        if ([self.datasArray[i] isEqualToString:self.currentTitle]) {
            UITableViewCell *selectCell = [tableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:i inSection:0]];
            selectCell.accessoryType = UITableViewCellAccessoryNone;
            self.currentTitle = nil;
            break;
        }
    }
    if (self.indexpathSelect) {
        UITableViewCell *selectCell = [tableView cellForRowAtIndexPath:self.indexpathSelect];
        selectCell.accessoryType = UITableViewCellAccessoryNone;
    }
    //更新记录，选中点击的cell
    self.indexpathSelect = indexPath;
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    cell.accessoryType = UITableViewCellAccessoryCheckmark;
    self.selectTitle = [self.datasArray objectAtIndex:indexPath.row];
    if (self.isBoolValue) {
        if (self.selectCellTitle) {
            self.selectCellTitle(self.selectTitle,self.indexpathSelect.row);
        }
    }
}

#pragma mark -确定
- (void)completeButtonClick:(UIBarButtonItem *)item
{
    [self dismissViewControllerAnimated:YES completion:nil];
    if (self.selectTitle || self.currentTitle) {
        if (self.selectCellTitle) {
            self.selectCellTitle(self.selectTitle?self.selectTitle:self.currentTitle,self.indexpathSelect.row);
        }
    }
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return KNODATAIMAGE;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *attributes = @{NSFontAttributeName: [UIFont boldSystemFontOfSize:15.0f], NSForegroundColorAttributeName: [UIColor darkGrayColor]};
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:attributes];
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}


@end
