//
//  MjRefreshHeaderCustom.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/20.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "MjRefreshHeaderCustom.h"

@implementation MjRefreshHeaderCustom

- (void)prepare
{
    [super prepare];
    // 设置普通状态的动画图片
    NSMutableArray *idleImages = [NSMutableArray array];
    for (int i = 1; i<=6; i++) {
        NSString *imageName = [NSString stringWithFormat:@"loading%d", i];
        UIImage *image = TCImage(imageName);
        [idleImages addObject:image];
    }
    [self setImages:idleImages forState:1];
    
    // 设置即将刷新状态的动画图片（一松开就会刷新的状态
    NSMutableArray *refreshingImages = [NSMutableArray array];
    for (int i = 1; i<=6; i++) {
        NSString *imageName = [NSString stringWithFormat:@"loading%d", i];
        UIImage *image = TCImage(imageName);
        [refreshingImages addObject:image];
    }
    [self setImages:refreshingImages forState:2];
    
     // 设置正在刷新状态的动画图片
    [self setImages:refreshingImages forState:3];
}

@end
