//
//  HttpRequestManager.m
//  total
//
//  Created by 曹云霄 on 16/6/24.
//  Copyright © 2016年 Delevin. All rights reserved.
//

#import "HttpRequestManager.h"
#import "AFNetworking.h"
@implementation HttpRequestManager



/**
 *  网络请求
 *
 *  @param requestString 请求链接
 *  @param requestType   POST or GET
 *  @param parameter     JSONModel
 *  @param success       成功返回
 *  @param failed        失败返回
 */
+ (void)requestNetworkwithURL:(NSString *)requestString
              withRequestType:(RequestType)requestType
                withParameter:(id)parameter
                  withSuccess:(returnValueBlock)success
                   withFailed:(failedValueBlock)failed
{
    AFHTTPSessionManager *manager = [AFHTTPSessionManager manager];
    manager.responseSerializer = [AFJSONResponseSerializer serializer];
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    manager.requestSerializer.timeoutInterval = 10.0f;
    [manager.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField:@"Content-Type"];
    ICRUserUtil *user = [ICRUserUtil sharedInstance];
    //添加企业认证码到请求头
    if(user.f_enterprise_uuid != NULL)
    {
        [manager.requestSerializer setValue:user.f_enterprise_uuid forHTTPHeaderField:@"enterprise"];
    }
    [manager.requestSerializer setValue:user.f_authenticode forHTTPHeaderField:@"authorization"];
    NSLog(@"%@",requestString);
    if (requestType) {
        [manager GET:requestString parameters:parameter success:^(NSURLSessionDataTask *task, id responseObject) {
              success(responseObject);
        } failure:^(NSURLSessionDataTask *task, NSError *error) {
            failed(error);
        }];
    } else {
        [manager POST:requestString parameters:parameter success:^(NSURLSessionDataTask *task, id responseObject) {
               success(responseObject);
        } failure:^(NSURLSessionDataTask *task, NSError *error) {
            failed(error);
        }];
    }
}


















@end
