//
//  UploadManager.h
//  patrol
//
//  Created by 曹云霄 on 2017/2/8.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PostAttachmentModel.h"

/**
 上传类型

 - UPLOAD_COMMON: 普通上传
 - UPLOAD_THIRDPARTY: 第三方上传
 */
typedef NS_ENUM(NSInteger,UPLOAD_TYPE){
    UPLOAD_COMMON = 0,
    UPLOAD_THIRDPARTY
};

@interface UploadResponse : NSObject


/**
 上传类型
 */
@property (nonatomic,assign) UPLOAD_TYPE type;

/**
 上传成功
 */
@property (nonatomic,strong) NSArray<PostAttachmentModel *>*response;

@end



@interface UploadManager : NSObject

+ (UPLOAD_TYPE)getUploadType;

+ (void)getAppOption;
/**
 上传文件

 @param array 文件array
 @param completed 完成回调
 @param failed 失败回调
 */
+ (void)uploadObjectArray:(NSArray<PostAttachmentModel *>*)array completed:(void (^)(UploadResponse *success))completed failed:(void(^)(NSString *error))failed;


@end
