//
//  GTOAppViewControllerManager.h
//  total
//
//  Created by freecui on 15/9/9.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "IBTObject.h"
#import "IBTTabBarController.h"

#define TO_NAME_HOME       @"首页"// @"Home"
#define TO_NAME_BUSINESS   @"业务"// @"Business"
#define TO_NAME_ME         @"我的"// @"Me"

typedef NS_ENUM(NSUInteger, CRTapBarItemIndex) {
    kTOHome = 0,
    kTOBusiness,
    kTOMe
};

static NSString *const ACETapBarItemNames[] = {
    [kTOHome]      = TO_NAME_HOME,
    [kTOBusiness]  = TO_NAME_BUSINESS,
    [kTOMe]        = TO_NAME_ME
};
@interface ICRAppViewControllerManager : IBTObject
{
    UIWindow *m_window;
    NSMutableArray *m_arrViewController;
    NSMutableArray *m_arrTabBarBaseViewController;
    IBTTabBarController *m_tabbarController;
}

+ (UINavigationController *)getCurrentNavigationController;
+ (IBTTabBarController *)getTabBarController;
+ (ICRAppViewControllerManager *)getAppViewControllerManager;

- (id)initWithWindow: (UIWindow *)window;
- (CGSize)getRootViewSize;
- (UIViewController *)getTablBaseViewController: (CRTapBarItemIndex)index;
- (IBTTabBarController *)getTabBarController;
- (NSUInteger)getCurTabBarIndex;

- (void)doLogout;

- (void)openFirstView;
- (void)openMainFrame;

- (void)createHomeViewController;
- (void)createBusinessController;
- (void)createMeController;
@end
