//
//  GTOPatrolPlan.h
//  total
//
//  Created by freecui on 15/9/11.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "IBTModel.h"


typedef NS_ENUM(NSUInteger, GTOPatrolPlanStatus) {
    kPatrolPlanStatusCreated = 0,
    kPatrolPlanStatusCommited,
    kPatrolPlanStatusProcessing,
    kPatrolPlanStatusFinished,
    kPatrolPlanStatusCanceld,
};

@interface GTOPatrolPlan : IBTModel
//@property (copy, nonatomic) NSString *uuid;
@property (copy, nonatomic) NSString *uuid; //
@property (assign, nonatomic) NSInteger version; // 数据库版本号
@property (copy, nonatomic) NSDate *create_time; // 创建时间
@property (copy, nonatomic) NSString *create_id; //  创建人代码
@property (copy, nonatomic) NSString *create_operName; // 创建人名称
@property (copy, nonatomic) NSString *lastModify_time;  //  最后修改时间
@property (copy, nonatomic) NSString *lastModify_id;  //  最后修改人代码
@property (copy, nonatomic) NSString *lastMOdify_operName;  //最后修改人名称
@property (copy, nonatomic) NSString *orgUuid;  //所属组织uuid
@property (copy, nonatomic) NSString *name;   // 巡名称
@property (copy, nonatomic) NSString *beginDate;  // 开始时间
@property (copy, nonatomic) NSString *endDate;   // 结束时间
@property (copy, nonatomic) NSString *category;  // 巡店类别
@property (assign, nonatomic) BOOL recordLocation;  //是否记录调整位置
@property (assign, nonatomic) GTOPatrolPlanStatus state;  // 状态  应该是后台的状态吧？？？？？
@property (copy, nonatomic) NSString *remark;  //说明
@property (copy, nonatomic) NSArray *questions;  //问题列表
@property (copy, nonatomic) NSArray *inspectors;  //巡店员列表

//另加
@property (nonatomic, assign) NSUInteger finishedStoreNumber;
@property (nonatomic, assign) NSUInteger totalStoreNumber;
@property (nonatomic, assign) CGFloat processLength;//任务进度：根据油站，油站根据巡检员的状态
@property (copy, nonatomic) NSArray *questionCategorys;

@end
