
//
//  GTOPatrolPlanResultTopItem.m
//  total
//  巡检任务列表的cell的内容
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPatrolPlanCellContentView.h"
#import "GTOPatrolPlan.h"
#import "GTOInspector.h"
@interface GTOPatrolPlanCellContentView ()
@property (strong, nonatomic) IBTUILabel *m_planNameLabel;
@property (strong, nonatomic) IBTUILabel *m_planStateLabel;
@property (strong, nonatomic) IBTUILabel *m_planStateValueLabel;
@property (strong, nonatomic) IBTUILabel *m_planTimeLabel;
@property (strong, nonatomic) IBTUILabel *m_processLabel;//完成进度
@property (strong, nonatomic) IBTUILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOPatrolPlanCellContentView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    self.m_planNameLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_planStateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_planStateValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_planTimeLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    self.m_processLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processFractionLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    
    [self addSubview:_m_planNameLabel];
    [self addSubview:_m_planStateLabel];
    [self addSubview:_m_planStateValueLabel];
    [self addSubview:_m_planTimeLabel];
    [self addSubview:_m_processLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processFractionLabel];
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_planNameLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH + 10,
    };
    _m_planStateLabel.frame = (CGRect){
        .origin.x = _m_planNameLabel.x,
        .origin.y = _m_planNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 100,
        .size.height = lblH,
    }; [_m_planStateLabel sizeToFit];
    _m_planStateValueLabel.frame = (CGRect){
        .origin.x = _m_planStateLabel.right,
        .origin.y = _m_planStateLabel.y,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING - _m_planStateLabel.width,
        .size.height = lblH,
    };
    _m_planTimeLabel.frame = (CGRect){
        .origin.x = _m_planNameLabel.x,
        .origin.y = _m_planStateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_processLabel.frame = (CGRect){
        .origin.x = _m_planTimeLabel.x,
        .origin.y = _m_planTimeLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 100,
        .size.height = lblH,
    };
    _m_processValueLabel.frame = (CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.y,
        .size.width = 120,
        .size.height = lblH,
    }; [_m_processValueLabel sizeToFit];
    _m_processFractionLabel.frame = (CGRect){
        .origin.x = SCREEN_SIZE.width - 100 - GTO_LEFT_PADDING,
        .origin.y = _m_processLabel.y,
        .size.width = 100,
        .size.height = lblH,
    }; [_m_processFractionLabel sizeToFit];
    
    CGRect rect = (CGRect){
        .origin.x = _m_processLabel.x,
        .origin.y = _m_processLabel.bottom + GTO_VERTICAL_PADDING ,
        .size.width = SCREEN_SIZE.width - _m_processLabel.x - GTO_LEFT_PADDING,
        .size.height = 20,
    };
    [self.m_processBarView removeFromSuperview];
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    [self addSubview:_m_processBarView];
}

@end

@implementation GTOPatrolPlanCellContentView (configure)
- (void)updateWithPatrolPlan: (GTOPatrolPlan *)patrolPlan
{
    
    _d_processLength = patrolPlan.processLength;
    self.m_planNameLabel.text = [NSString stringWithFormat:@"%@",patrolPlan.name];
    self.m_planTimeLabel.text = [NSString stringWithFormat:@"计划时间： %@ ~ %@",patrolPlan.beginDate ,patrolPlan.endDate ];//[NSString stringWithFormat:@"最后修改时间：%@ ",patrolPlan.lastModify_time];//
    self.m_processLabel.text = [NSString stringWithFormat:@"巡检总进度: "];
    self.m_planStateLabel.text = @"状态: ";
    NSString *stateStr = [NSString stringWithFormat:@"%ld",patrolPlan.state];
    self.m_planStateValueLabel.text = [GTOCommonTools patrolStateChineseWithEnglish:stateStr];
    if (patrolPlan.state == kPatrolPlanStatusProcessing) {
        self.m_planStateValueLabel.textColor = GTO_RED_COLOR;
    } else {
        self.m_planStateValueLabel.textColor = GTO_GRAY_TINT_COLOR;
    }
    self.d_processLength =  patrolPlan.processLength;//finishStores * 1.0 / totalStores;
    int percent = patrolPlan.processLength * 100;
    if (patrolPlan.finishedStoreNumber == patrolPlan.totalStoreNumber) {
        self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
        self.m_processValueLabel.textColor = GTO_GRAY_TINT_COLOR;
        self.m_processFractionLabel.textColor = GTO_GRAY_TINT_COLOR;
    } else {
        self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
        self.m_processValueLabel.textColor = GTO_BLUE_TINT_COLOR;
        self.m_processFractionLabel.textColor = GTO_BLUE_TINT_COLOR;
    }
    
    self.m_processFractionLabel.text = [NSString  stringWithFormat:@"%ld/%ld(油站)",patrolPlan.finishedStoreNumber,patrolPlan.totalStoreNumber];
//    self.m_processBarView = [[IBTUIView alloc]initWithFrame:self.m_processBarView.frame processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
//    [self addSubview:_m_processBarView];

    
    
    [self layoutSubviews];
}
@end
