//
//  GTOLicenceBoltView.m
//  total
//
//  Created by freecui on 15/10/30.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOLicenceBoltView.h"

#import "MaskCell.h"
#define TableHeight 45
#define LeftMargin 80
#define TotalHeight 224
#define LeftHeight 44
#define BottomHeight 50

@interface GTOLicenceBoltView ()<UITextFieldDelegate>
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
    UIButton *_currentRiskBtn;
    NSIndexPath *_currentRiskIndexPath;
    
   // UIView *_repairNumberView;
    UIView *_billNumberView;


    
    NSString *_state;
    UIButton *_clearBtn;
}
@property (nonatomic,strong)NSString *state;
//@property (nonatomic,strong)NSString *repairNumber;
@property (nonatomic,strong)NSString *billNumber;
@property (nonatomic,strong)NSString *riskGrade;

@end

@implementation GTOLicenceBoltView
- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state   billNumber:(NSString *)billNumber riskGrade: (NSString *)riskGrade {
    self = [super initWithFrame:frame];
    if (self) {
        self.state = state;
        self.billNumber = billNumber;
        self.riskGrade = riskGrade;
        [self createView];
        [self createRightView];
        [self preferData];
    }
    return self;

}
//- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state repairNumber:(NSString *)repairNumber  billNumber:(NSString *)billNumber riskGrade: (NSString *)riskGrade {
//    self = [super initWithFrame:frame];
//    if (self) {
//        self.state = state;
//        self.repairNumber = repairNumber;
//        self.billNumber = billNumber;
//        self.riskGrade = riskGrade;
//        [self createView];
//        [self createRightView];
//        [self preferData];
//    }
//    return self;
//}

- (void)preferData{
    
    if ([self.state isEqualToString:@"none"]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.state isEqualToString:GTO_LICENCE_STATE_INITIAL]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }else if ([self.state isEqualToString:GTO_LICENCE__STATE_SUBMITTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
    }else if ([self.state isEqualToString:GTO_LICENCE__STATE_APPROVED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:3 inSection:0];
    }else if ([self.state isEqualToString:GTO_LICENCE__STATE_REJECTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:4 inSection:0];
    }else if ([self.state isEqualToString:GTO_LICENCE__STATE_EXPIRED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:5 inSection:0];
    }else if ([self.state isEqualToString:GTO_LICENCE__STATE_FINISHED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:6 inSection:0];
    } else {
    
    }
    
    
    if ([self.riskGrade isEqualToString:@"none"]) {
        _currentRiskIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.riskGrade isEqualToString:GTO_LICENCE_RISK_HIGHT]) {
        _currentRiskIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }else if ([self.riskGrade isEqualToString:GTO_LICENCE__RISK_MIDDLE]) {
        _currentRiskIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
    } else {
        
    }

    self.tableViewRisk.hidden = YES;
//    _billNumberView.hidden = YES;
//    if(self.title.length > 0){
//        self.billNumberFiled.text = self.title;
//    }
//    _billNumberView.hidden = YES;
//    if (self.billNumber.length > 0) {
//        self.riskGradeFiled.text = self.billNumber;
//    }
//    _billNumberView.hidden = YES;
//    if(self.title.length > 0){
//        self.billNumberFiled.text = self.title;
//    }
//    _billNumberView.hidden = YES;
//    if (self.billNumber.length > 0) {
//        self.riskGradeFiled.text = self.billNumber;
//    }
}
#pragma mark - 创建视图
- (void)createView
{
    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height- BottomHeight)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态",@"风险等级",@"单号"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:GXF_DETAIL_COLOR forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    _clearBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _clearBtn.frame = CGRectMake(0, CGRectGetMaxY(_leftView.frame), self.frame.size.width, BottomHeight);
    [_clearBtn setTitle:@"清空选项" forState:UIControlStateNormal];
    [_clearBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    _clearBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_clearBtn addTarget:self action:@selector(clearBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_clearBtn];
}

- (void)createRightView{
    
//    CGRect viewRect = CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight);
//    CGRect lblRect = CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20);
//    CGRect textFRect = CGRectMake(10, 20 + 20 + 10, (ScreenSize.width - LeftMargin - 10*2), 30);
    _billNumberView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight)];
    _billNumberView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_billNumberView];
    UILabel *titleLabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20)];
    titleLabel.font = GXF_FIFTEENTEN_SIZE;
    titleLabel.text = @"类似于：";
    [_billNumberView addSubview:titleLabel];
    self.billNumberFiled = [[UITextField alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(titleLabel.frame) + 10, (ScreenSize.width - LeftMargin - 10*2), 30)];
    self.billNumberFiled.textAlignment = NSTextAlignmentLeft;
    self.billNumberFiled.textColor = GXF_CONTENT_COLOR;
    self.billNumberFiled.placeholder = @"输入类似单号";
    self.billNumberFiled.borderStyle = UITextBorderStyleRoundedRect;
    self.billNumberFiled.font = GXF_FIFTEENTEN_SIZE;
    self.billNumberFiled.returnKeyType = UIReturnKeyDone;
    self.billNumberFiled.delegate = self;
    [_billNumberView addSubview:self.billNumberFiled];
    
    self.tableViewState = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableViewState.backgroundColor = [UIColor whiteColor];
    self.tableViewState.tag = kTableViewStateTag;
    self.tableViewState.delegate = self;
    self.tableViewState.dataSource = self;
    [self addSubview:self.tableViewState];
    
    self.tableViewRisk = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableViewRisk.backgroundColor = [UIColor whiteColor];
    self.tableViewRisk.tag = kTableViewRiskTag;
    self.tableViewRisk.delegate = self;
    self.tableViewRisk.dataSource = self;
    
    [self addSubview:self.tableViewRisk];
    
}
- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [self keyBoardHidden];
    switch (btn.tag) {
        case 1001://状态
        {
            self.tableViewState.hidden = NO;
             self.tableViewRisk.hidden = YES;
            _billNumberView.hidden = YES;
        }
            break;
        case 1002://条件二
        {
            self.tableViewState.hidden = YES;
            self.tableViewRisk.hidden = NO;
            _billNumberView.hidden = YES;
        }
            break;
        case 1003://条件三
        {
            self.tableViewState.hidden = YES;
            self.tableViewRisk.hidden = YES;
            _billNumberView.hidden = NO;
        }
            break;

        default:
            break;
    }
}

- (void)clearBolt{
//    if (_repairNumberFiled.text.length > 0) {
//        _repairNumberFiled.text = @"";
//    }
    if (_billNumberFiled.text.length > 0) {
        _billNumberFiled.text = @"";
    }
//    if (_riskGradeFiled.text.length > 0) {
//        _riskGradeFiled.text = @"";
//    }

    if (_currentIndexPath) {
        _currentIndexPath = nil;
        [self.tableViewState reloadData];
    }
    if (_currentRiskIndexPath) {
        _currentRiskIndexPath = nil;
        [self.tableViewRisk reloadData];
    }
    if ([self.delegate respondsToSelector:@selector(clearBoltInformation)]) {
        [self.delegate clearBoltInformation];
    }
}

#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return  tableView.tag == kTableViewStateTag ?  self.dataArrState.count : self.dataArrRisk.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    switch (tableView.tag) {
        case kTableViewStateTag:
        {
            if (_dataArrState.count > 0) {
                cell.Commitbtn.hidden = YES;
                [cell setTitleStr:self.dataArrState[indexPath.row]];
                
            }
            if (_currentIndexPath) {
                if (indexPath.row == _currentIndexPath.row) {
                    cell.Commitbtn.hidden = NO;
                }else{
                    cell.Commitbtn.hidden = YES;
                }
            }

        }
            break;
        case kTableViewRiskTag:
        {
            if (_dataArrRisk.count > 0) {
                cell.Commitbtn.hidden = YES;
                [cell setTitleStr:self.dataArrRisk[indexPath.row]];
                
            }
            if (_currentRiskIndexPath) {
                if (indexPath.row == _currentRiskIndexPath.row) {
                    cell.Commitbtn.hidden = NO;
                }else{
                    cell.Commitbtn.hidden = YES;
                }
            }

        }
            break;
        default:
            break;
    }
       return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    switch (tableView.tag) {
        case kTableViewStateTag:
        {
            //获取选中的cell
            MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
            currentCell.Commitbtn.hidden = YES;
            MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
            cell.Commitbtn.hidden = NO;
            _currentIndexPath = indexPath;
            
            
            NSString *stateStr = @"";
            if (indexPath.row == 0) {
                stateStr = @"none";
            }else if(indexPath.row == 1){
                stateStr = GTO_LICENCE_STATE_INITIAL;
            }else if(indexPath.row == 2){
                stateStr = GTO_LICENCE__STATE_SUBMITTED;
            }else if(indexPath.row == 3){
                stateStr = GTO_LICENCE__STATE_ASKFORAPPROVE;
            }else if(indexPath.row == 4){
                stateStr = GTO_LICENCE__STATE_APPROVED;
            }else if(indexPath.row == 5){
                stateStr =GTO_LICENCE__STATE_REJECTED;
            }else if(indexPath.row == 6){
                stateStr = GTO_LICENCE__STATE_APPROVED;
            }else if(indexPath.row == 7){
                stateStr =GTO_LICENCE__STATE_FINISHED;
            }
            [self.delegate getBoltValueSelectRow:stateStr];
        }
            break;
        case kTableViewRiskTag:
        {
            //获取选中的cell
            MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentRiskIndexPath];
            currentCell.Commitbtn.hidden = YES;
            MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
            cell.Commitbtn.hidden = NO;
            _currentRiskIndexPath = indexPath;
            
            
            NSString *stateStr = @"";
            if (indexPath.row == 0) {
                stateStr = @"none";
            }else if(indexPath.row == 1){
                stateStr = GTO_LICENCE_RISK_HIGHT;
            }else if(indexPath.row == 2){
                stateStr = GTO_LICENCE__RISK_MIDDLE;
            }else {
                
            }
            [self.delegate getBoltRiskValueSelectRow:stateStr];
        }
            break;

        default:
            break;
    }
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self keyBoardHidden];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self keyBoardHidden];
}
- (void)keyBoardHidden{
   // [self.repairNumberFiled resignFirstResponder];
    [self.billNumberFiled resignFirstResponder];

}

- (void)textFieldDidEndEditing:(UITextField *)textField{
//    if (textField == self.repairNumberFiled) {
//        //        if (self.billNumberFiled.text.length > 0) {
//        [self.delegate getRepairNumberLike:self.repairNumberFiled.text];
//        //        }
//    }else
        if(textField == self.billNumberFiled){
        //        if (self.riskGradeFiled.text.length > 0) {
        [self.delegate getBillNumber:self.billNumberFiled.text];
        //        }
    }
//    if (textField == self.riskGradeFiled) {
//        //        if (self.billNumberFiled.text.length > 0) {
//        [self.delegate getRiskGrade:self.riskGradeFiled.text];
//        //        }
//    }else {
//
//    }

}


@end
