//
//  SeePriceDetailsTableViewCell.m
//  total
//
//  Created by 曹云霄 on 16/6/21.
//  Copyright © 2016年 free. All rights reserved.
//

#import "SeePriceDetailsTableViewCell.h"
#import "SeePriceCollectionViewCell.h"
#import "SeePriceCollectionReusableView.h"

@implementation SeePriceDetailsTableViewCell


- (void)awakeFromNib {
    [super awakeFromNib];
    
    [self uiConfigAction];
}

- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

#pragma mark -赋值
- (void)setDatasResult:(QueryResult *)datasResult
{
    _datasResult = datasResult;
    NSArray *array = _datasResult.records;
    [self.datasArray removeAllObjects];
    for (NSDictionary *dict in array) {
        [self.datasArray addObject:[[dict objectForKey:@"item"] objectForKey:@"name"]];
        [self.datasArray addObject:[[dict objectForKey:@"guidancePrice"] stringValue]];
        [self.datasArray addObject:[[dict objectForKey:@"salePrice"] stringValue]];
    }
    [self.priceDetailsCollectionView reloadData];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.priceDetailsCollectionLayout.itemSize = CGSizeMake(((ScreenSize.width-16)/3), 40);
    self.priceDetailsCollectionLayout.minimumLineSpacing = 0;
    self.priceDetailsCollectionLayout.minimumInteritemSpacing = 0;
    self.priceDetailsCollectionView.dataSource = self;
    self.priceDetailsCollectionView.delegate = self;
    self.priceDetailsCollectionView.emptyDataSetSource = self;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    SeePriceCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"SeePriceCollectionViewCell" forIndexPath:indexPath];
    cell.priceDetailsLabe.text = [self.datasArray objectAtIndex:indexPath.row];
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.datasArray.count;
}



#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return KNODATAIMAGE;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *attributes = @{NSFontAttributeName: [UIFont boldSystemFontOfSize:15.0f], NSForegroundColorAttributeName: [UIColor darkGrayColor]};
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:attributes];
}






@end
