//
//  ICRAppMacro.h
//  Cruiser
//
//  Created by Xummer on 15/3/25.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#ifndef Cruiser_ICRAppMacro_h
#define Cruiser_ICRAppMacro_h

// COLOR
#define ICR_TINTCOLOR                   [UIColor colorWithR:63 g:134 b:244 a:1]//天蓝色
#define ICR_VIEW_BG_COLOR               [UIColor whiteColor]

#define ICR_GRAY_BTN_COLOR              [UIColor lightGrayColor]
#define ICR_ORANGE_BTN_COLOR            [UIColor colorWithR:250 g:155 b:52 a:1]
#define ICR_DISABLE_BTN_COLOR           [UIColor colorWithW:202 a:1]
#define ICR_NAVIBAR_ITEM_COLOR          [UIColor whiteColor]
#define ICR_NAVIBAR_ITEM_DISABLE_COLOR  [UIColor colorWithW:1 a:.5f]
#define ICR_NAVIBAR_TITLE_COLOR         [UIColor whiteColor]
#define ICR_TABBAR_TINT_COLOR           [UIColor colorWithR:36 g:38 b:53 a:1] //黑色
#define ICR_IMAGE_BG_COLOR              [UIColor colorWithW:242 a:1]




// Import Headers
#import "GTOUtilsMacro.h"
#import "GTOVendorMacro.h"
#import "ICRHTTPController.h"
#import "ICRUserUtil.h"
#import "ICRAppViewControllerManager.h"
#import "ICRDataBaseController.h"
#import "NSData+EncodeAdditions.h"
#import "UIScrollView+Content.h"
#import "GTOCommonTools.h"



#define HexColor(colorStr)      [UIColor colorWithHexString:colorStr]
#define RGBA(R,G,B,A)           [UIColor colorWithRed:R/255.0f green:G/255.0f blue:B/255.0f alpha:A]
#define ScreenSize              ([[UIScreen mainScreen] bounds].size)
#define IOS7                    ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0)
#define FontSize(num)           [UIFont systemFontOfSize:num]
#define AppWindow               [[UIApplication sharedApplication].delegate window]
#define GXF_NSUSERFEFTAULTS     [NSUserDefaults standardUserDefaults]




//先锋水果
#define GXF_THREETEENTH_SIZE    FontSize(13)
#define GXF_FOURTEENTH_SIZE     FontSize(14)
#define GXF_FIFTEENTEN_SIZE     FontSize(15)
#define GXF_SIXTEENTEH_SIZE     FontSize(16)
#define GXF_SEVENTEENTH_SIZE    FontSize(17)


//高度
#define SEARCH_TABLECELL_HEIGHT 50


//类型
#define GTO_PATROL_TEMPLATE        @"GTOPatrolTemplate"
#define GXF_BASECLASS_USER          @"User"
//选中的颜色
#define BASESELECT_COLOR                                RGBA(255, 127, 0, 1)
#define GXF_CONTENT_COLOR       HexColor(@"444444")
#define WS(weakSelf)  __weak __typeof(&*self)weakSelf = self



//total


////阿里云测试
//#define HTTP_REST_API_BASE_URL        @"http://218.244.151.129:7580/total-server/rest" //
//#define HTTP_LOCAL_BASE_URL    @"http://218.244.151.129:7580"

////正式环境
//#define HTTP_REST_API_BASE_URL        @"http://139.196.39.77:7080/total-server/rest"
//#define HTTP_LOCAL_BASE_URL    @"http://139.196.39.77:7080"
//
//测试环境
#define HTTP_REST_API_BASE_URL        @"http://139.196.39.77:8180/total-server/rest"
#define HTTP_LOCAL_BASE_URL    @"http://139.196.39.77:8180"

//
//测试环境
//#define HTTP_REST_API_BASE_URL        @"http://139.196.39.77:8080/total-server/rest" 

//开发环境
//#define HTTP_LOCAL_BASE_URL    @"http://139.196.195.30:8093"
//#define HTTP_REST_API_BASE_URL        @"http://139.196.195.30:8093/total-server/rest"

#define    HTTP_WEATHER_URL @"http://apis.baidu.com/heweather/weather/free"

//refreshUpdateDate
#define PurchaseNoticeUpdateDate    @"purchaseNoticeUpdateDate"
#define TemplateNameUpdateDate    @"templateNameUpdateDate"
//color  以巡检结果显示的界面为标准
#define GTO_LINE_COLOR          HexColor(@"e5e5e5")
#define GTO_GRAY_TINT_COLOR        HexColor(@"#6C6C6C")   //17 topView
#define GTO_GRAY_SHALLOW_TINT_COLOR   HexColor(@"#C6C6C6")   // category 较浅的灰色
#define GTO_BLUE_TINT_COLOR        HexColor(@"#226AAD")   //17 topView
#define GTO_BLUE_SHALLOW_TINT_COLOR   HexColor(@"#71D2F4")   // category 较浅的蓝色
#define GTO_BLUE_DEEP_COLOR   HexColor(@"#005CA5") // 深蓝
#define GTO_RED_COLOR   HexColor(@" #E6002E")  //红色
#define GTO_GREEN_COLOR   HexColor(@"#7FD18D")  //红色
#define   GXF_ORIGIN_COLOR HexColor(@"f69100") //橙色
#define GTO_BACKGROUND_GRAY_SHALLOW_COLOR              RGBA(246,246,246,1)

//间距
#define GTO_LEFT_PADDING     (15)
#define GTO_VERTICAL_PADDING     (7)
#define GTO_TOP_VERTICAL_PADDING     (7)

#define ICR_BLUE_BTN_COLOR              ICR_TINTCOLOR

#define XXFBgColor              RGBA(246,246,246,1)

#define NavigationBarHeight 64
#define BottomViewHeight 60


#define SCREEN_SIZE  [UIScreen mainScreen].bounds.size


//问题类型
typedef NS_ENUM(NSUInteger, ICRQestionType) {
    kICRQestionTypeSingleSel = 0,
    kICRQestionTypeMultipleSel,
    kICRQestionTypeReply,
    kICRQestionTypeScore,
    kICRQestionTypeStoreInv,
    kICRQestionTypeSpeciesInv,
    kICRQestionTypeStarNum,
    kICRQestionTypeSingleScore//单选打分（新增加）
};

#define GXF_DETAIL_COLOR        HexColor(@"888888")
//refreshUpdateDate
#define GTO_REPAIR_UPDATEDATE             @"repairUpdateDate"
//拓站 任务状态
#define GTO_PIONEERING_STATE_LOCAL  @"local"
#define GTO_PIONEERING_STATE_INITIAL  @"initial"
#define GTO_PIONEERING_STATE_SUBMITTED  @"submitted"
//#define GTO_PIONEERING_STATE_FINISHED  @"finished"

//报修状态
#define GTO_REPAIR_STATE_INITIAL  @"initial"
#define GTO_REPAIR_STATE_SUBMITTED  @"submitted"  //后台已经提交，而且没有一个许可证时，为”待处理“
#define GTO_REPAIR_STATE_PROCESSING  @"processing"//至少有一个许可证
#define GTO_REPAIR_STATE_APPLICATION  @"application"
#define GTO_REPAIR_STATE_FINISHED  @"finished"

//许可证状态
#define GTO_LICENCE_STATE_LOCAL  @"local"
#define GTO_LICENCE_STATE_INITIAL  @"initial"
#define GTO_LICENCE__STATE_SUBMITTED  @"submitted"
#define GTO_LICENCE__STATE_ASKFORAPPROVE @"askforapprove"
#define GTO_LICENCE__STATE_APPROVED  @"approved"
#define GTO_LICENCE__STATE_REJECTED  @"rejected"
#define GTO_LICENCE__STATE_EXPIRED @"expired"
#define GTO_LICENCE__STATE_FINISHED  @"finished"
//许可证风险等级
#define GTO_LICENCE_RISK_HIGHT  @"高"
#define GTO_LICENCE__RISK_MIDDLE  @"中"

//附件的 实体类型
#define GTO_ENTITYTYPE_AFFICHE   @"affiche"   //公告
#define GTO_ENTITYTYPE_EMPLATE   @"template"  //所以模板
#define GTO_ENTITYTYPE_PATROL_QUESTION   @"patrolQuestion"  //巡检问题
#define GTO_ENTITYTYPE_PATROL_ANSWER   @"patrolAnswer"   //巡检结果
#define GTO_ENTITYTYPE_LICENCE_QUESTION   @"licenceQuestion"  //许可证问题
#define GTO_ENTITYTYPE_LICENCE_ANSWER   @"licenceAnswer"  //许可证结果
#define GTO_ENTITYTYPE_PIONEER_QUESTION  @"pioneerQuestion" //拓站问题
#define GTO_ENTITYTYPE_PIONEER_ANSWER   @"pioneerAnswer" //拓站结果
#define GTO_ENTITYTYPE_REPAIR   @"repair"  //保修单

//巡检
// 下载巡检任务的时间类型
#define GTO_PATROL_DATE_TYPE_BEFORE @"before"
#define GTO_PATROL_DATE_TYPE_AFTER @"after"
//巡检状态
#define GTO_PATROL_STATE_INITIAL @"0"
#define GTO_PATROL_STATE_SUBMITTED @"1"
#define GTO_PATROL_STATE_PROCESSING @"2"
#define GTO_PATROL_STATE_FINISHED @"3"
#define GTO_PATROL_STATE_CANCLED @"4"













////许可证结果页面审批时 ：是由哪个界面跳转过来的：1.查看报修， 2.查看许可证， 3.许可证审批
//#define GTO_LICENCE__PUSH_REPAIR  @"repair"
//#define GTO_LICENCE__PUSH_LICENCE_SEE @"licenceSee"
//#define GTO_LICENCE__PUSH_LICENCE_CHECK  @"licenceCheck"
#endif
