
//
//  VankeAppBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/10/11.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeAppBoard_iPhone.h"
#import "VankeUtil.h"
#import "VankeMainBoard_iPhone.h"
#import "VankeLoginBoard_iPhone.h"
#import "VankeAffairsBoard_iPhone.h"
#import "VankeSettingsBoard_iPhone.h"
#import "VankeMainTabBoard_iPhone.h"

#pragma mark -

@interface VankeAppBoard_iPhone ()
{
    BeeUIRouter *               _router;
    UIWindow *                  _login;
    VankeMainTabBoard_iPhone*   _tabbar;
}
@end

@implementation VankeAppBoard_iPhone

DEF_SINGLETON( VankeAppBoard_iPhone )

//SUPPORT_AUTOMATIC_LAYOUT( YES )
//SUPPORT_RESOURCE_LOADING( YES )

//DEF_OUTLET(BeeUIView, contentView)
//DEF_OUTLET(VankeMainTabBoard_iPhone, tabbar)

DEF_NOTIFICATION( HIDE_MENU )
//DEF_NOTIFICATION( SHOW_MENU )

- (void)load
{
}

- (void)unload
{
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.view.backgroundColor = [VankeUtil colorWithHexString:@"#fafafa"];
    
    _router = [BeeUIRouter sharedInstance];
    _router.parentBoard = self;
    _router.view.alpha = 0.0f;
    [_router map:@"home" toClass:[VankeMainBoard_iPhone class]];
    [_router map:@"affairs" toClass:[VankeAffairsBoard_iPhone class]];
    [_router map:@"me" toClass:[VankeSettingsBoard_iPhone class]];
    [self.view addSubview:_router.view];
    
    _tabbar = [VankeMainTabBoard_iPhone cell];
    [self.view addSubview:_tabbar];
    
    [self createAndShowLoginWindow];
    [self observeNotification:VankeLoginBoard_iPhone.SUCC_LOGIN];
    [self observeNotification:VankeSettingsBoard_iPhone.SUCC_LOGOUT];
    [self observeNotification:VankeAppBoard_iPhone.HIDE_MENU];
    
    [_router open:@"home" animated:NO];
}

ON_DELETE_VIEWS( signal )
{
    _login = nil;
    [self unobserveAllNotifications];
}

ON_LAYOUT_VIEWS( signal )
{
    [self relayoutContentView];
}

ON_WILL_APPEAR( signal )
{
}

ON_DID_APPEAR( signal )
{
    _router.view.pannable = YES;
}

ON_WILL_DISAPPEAR( signal )
{
    _router.view.pannable = NO;
}

ON_DID_DISAPPEAR( signal )
{
}

- (void)showMenu
{
    [self postNotification:self.HIDE_MENU withObject: @"NO"];
}

- (void)hideMenu
{
    [self postNotification:self.HIDE_MENU withObject: @"YES"];
}

#pragma notification

ON_NOTIFICATION3( VankeLoginBoard_iPhone, SUCC_LOGIN, notification )
{
    [UIView beginAnimations:@"fadeIn" context:nil];
    [UIView setAnimationDuration:0.5];
    [self removeLoginWindow];
    _router.view.alpha = 1.0f;
    [UIView commitAnimations];
    
    // 打开默认页面
    [_router open:@"home" animated:NO];
    BeeUIBoard *curBoard = _router.currentBoard;
    if (nil != curBoard && [curBoard isKindOfClass:[VankeMainBoard_iPhone class]]) {
        [((VankeMainBoard_iPhone*) curBoard).summaryModel reload];
    }
}

ON_NOTIFICATION3( VankeSettingsBoard_iPhone, SUCC_LOGOUT, notification )
{
    [self createAndShowLoginWindow];
    
    _router.view.alpha = 0.0f;
    [_tabbar selectHome];
    [_router open:@"home" animated:NO];
}

ON_NOTIFICATION3( VankeAppBoard_iPhone, HIDE_MENU, notification )
{
    NSString *userObj = notification.object;
    if ([@"YES" eq:userObj]) {
        _tabbar.hidden = YES;
    } else {
        _tabbar.hidden = NO;
    }
    [self relayoutContentView];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, home, signal )
{
    [_router open:@"home" animated:YES];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, affairs, signal )
{
    [_router open:@"affairs" animated:YES];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, me, signal )
{
    [_router open:@"me" animated:YES];
}

-(void) createAndShowLoginWindow {
    // 先检查登录
    _login = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
    _login.rootViewController = [VankeLoginBoard_iPhone board];
    _login.windowLevel = UIWindowLevelStatusBar + 1;
    [_login makeKeyAndVisible];
}

/**
 *  重置router和菜单
 */
-(void) relayoutContentView {
    CGFloat padding = 5.0f;
    
    CGRect frame1;
    frame1.size.width = self.viewSize.width;
    frame1.size.height = 45.0f;
    frame1.origin.x = 0.0;
    frame1.origin.y = self.view.bounds.size.height - 45.0f;
    _tabbar.frame = frame1;
    
    CGRect frame2;
    frame2.size.width = self.viewSize.width;
    if (_tabbar.hidden) {
        frame2.size.height = self.viewSize.height;
    } else {
        frame2.size.height = self.viewSize.height - 45.0f;
    }
    frame2.origin.x = 0.0;
    frame2.origin.y = 0.0;
    _router.view.frame = frame2;
}

/**
 *  删除登录窗口
 */
-(void) removeLoginWindow {
    [_login removeFromSuperview];
    _login = nil;
}

@end
