//
//  NSMutableArray+SafeInsert.h
//  Cruiser
//
//  Created by Xummer on 4/10/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSMutableArray (SafeInsert)
- (void)safeAddObject:(id)object;
- (void)safeInsertObject:(id)object atIndex:(NSUInteger)index;
- (void)safeRemoveObjectAtIndex:(NSUInteger)index;
- (void)safeReplaceObjectAtIndex:(NSUInteger)index withObject:(id)object;
- (void)removeFirstObject;
@end

@interface NSMutableDictionary (SafeInsert)
- (void)safeSetObject:(id)object forKey:(id<NSCopying>)key;
- (void)safeRemoveObjectForKey:(id)key;
@end

@interface NSMutableSet (SafeInsert)
- (void)safeAddObject:(id)object;
- (void)safeRemoveObject:(id)object;
@end

@interface NSMutableString (SafeInsert)
- (void)safeAppendString:(NSString *)string;
@end

@interface NSArray (SafeFetch)

- (id)safeObjectAtIndex:(NSUInteger)index;

@end