//
//  UIViewController+LogicController.m
//  Cruiser
//
//  Created by Xummer on 15/4/3.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "UIViewController+LogicController.h"

@implementation UINavigationController (ShouldPopOnBackButton)

- (BOOL)navigationBar:(UINavigationBar *)navigationBar shouldPopItem:(UINavigationItem *)item {
    
    if([self.viewControllers count] < [navigationBar.items count]) {
        return YES;
    }
    
    UIViewController* vc = [self topViewController];
    if([vc respondsToSelector:@selector(onBackButtonClicked)]) {
        [vc onBackButtonClicked];
    }
    else {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self popViewControllerAnimated:YES];
        });
    }
    
//    if(shouldPop) {
//        dispatch_async(dispatch_get_main_queue(), ^{
//            [self popViewControllerAnimated:YES];
//        });
//    }
//    else {
//        // Workaround for iOS7.1. Thanks to @boliva - http://stackoverflow.com/posts/comments/34452906
//        for(UIView *subview in [navigationBar subviews]) {
//            if(subview.alpha < 1.) {
//                [UIView animateWithDuration:.25 animations:^{
//                    subview.alpha = 1.;
//                }];
//            }
//        }
//    }
    
    return NO;
}

@end

#define HIDE_BOTTOMBAR_HIERARCHY    (2) // >= 2 从第几层开始hideTabBar

@implementation UIViewController (LogicController)

- (UIImage *)getViewControllerImage:(CGSize)imageSize {
    CGFloat scale = [[UIScreen mainScreen] scale];
    
    UIImage *snapshot = nil;
    UIGraphicsBeginImageContextWithOptions(self.view.bounds.size, NO, scale);
    {
        if ([self.view respondsToSelector:@selector(drawViewHierarchyInRect:afterScreenUpdates:)]) {
            [self.view drawViewHierarchyInRect:self.view.bounds afterScreenUpdates:YES];
        }
        else {
            [self.view.layer renderInContext:UIGraphicsGetCurrentContext()];
        }
        
        snapshot = UIGraphicsGetImageFromCurrentImageContext();
    }
    UIGraphicsEndImageContext();
    return snapshot;
}

#pragma mark - Navigation
- (BOOL)isCurrentViewController {
    UIViewController * vc = [self.navigationController topViewController];
    return vc == self;
}

- (void)onBackButtonClicked {
    dispatch_async(dispatch_get_main_queue(), ^{
        [self PopViewControllerAnimated:YES];
    });
}

- (UIViewController *)getViewControllerAtIndex:(NSInteger)iIndex {
    NSInteger legalIndex = iIndex;
    NSInteger maxCount = [self.navigationController.viewControllers count];
    
    if (legalIndex < 0) {
        legalIndex = MAX((maxCount - 1 + legalIndex), 0);
    }
    
    if (legalIndex >= maxCount) {
        return nil;
    }
    
    return self.navigationController.viewControllers[ legalIndex ];
}

- (void)PushViewController:(UIViewController *)viewController animated:(BOOL)bAnimated {
    BOOL isFirstHideTabbarCtrl = NO;
    
    UINavigationController *rootNavCtrl = self.navigationController;
    
    while (rootNavCtrl.navigationController) {
        rootNavCtrl = rootNavCtrl.navigationController;
    }
    
    if (rootNavCtrl.tabBarController) {
        if ([self.navigationController.viewControllers count] == (HIDE_BOTTOMBAR_HIERARCHY - 1)) {
            isFirstHideTabbarCtrl = YES;
        }
        
        viewController.hidesBottomBarWhenPushed = YES;
        self.hidesBottomBarWhenPushed = YES;
    }
    
    [self.navigationController pushViewController:viewController animated:bAnimated];
    
    if (isFirstHideTabbarCtrl) {
        self.hidesBottomBarWhenPushed = NO;
    }
}

- (UIViewController *)PopViewControllerAnimated:(BOOL)bAnimated {
    return [self.navigationController popViewControllerAnimated:bAnimated];
}

- (NSArray *)PopToViewController:(UIViewController *)viewController animated:(BOOL)bAnimated {
    return [self.navigationController popToViewController:viewController animated:bAnimated];
}

- (NSArray *)PopToRootViewControllerAnimated:(BOOL)bAnimated {
    return [self.navigationController popToRootViewControllerAnimated:bAnimated];
}

- (NSArray *)PopToViewControllerWithClass:(Class)vcClass animated:(BOOL)bAnimated {
    NSEnumerator *currentVCs = [self.navigationController.viewControllers reverseObjectEnumerator];
    UIViewController *foundVC = nil;
    for (UIViewController *vc in currentVCs) {
        if ([vc isKindOfClass:vcClass]) {
            foundVC = vc;
            break;
        }
    }
    
    if (foundVC) {
        return [self.navigationController popToViewController:foundVC animated:bAnimated];
    }
    else {
        return nil;
    }
}

- (NSArray *)PopToViewControllerAtIndex:(NSInteger)index animated:(BOOL)bAnimated {
    UIViewController *vc = [self getViewControllerAtIndex:index];
    if (!vc) {
        return nil;
    }
    return [self.navigationController popToViewController:vc animated:bAnimated];
}

@end

#import "IBTUINavigationController.h"
@implementation UIViewController (ModalView)

//- (void)releasePopoverController:(id)controller;
//- (void)popoverControllerDidDismissPopover:(id)popoverController;

- (void)DismissMyselfAnimated:(BOOL)bAnimated {
    [self.presentingViewController dismissViewControllerAnimated:bAnimated completion:NULL];
}

- (void)DismissModalViewControllerAnimated:(BOOL)bAnimated {
    [self dismissViewControllerAnimated:bAnimated completion:NULL];
}

- (void)PresentModalViewController:(UIViewController *)viewControllerToPresent animated:(BOOL)bAnimated {
    [self presentViewController:viewControllerToPresent animated:bAnimated completion:NULL];
}

- (void)PresentViewControllerInNewNavigation:(UIViewController *)viewControllerToPresent    animated:(BOOL)bAnimated completion:(void (^)(void))completion {
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:viewControllerToPresent];
    [self presentViewController:navCtrl animated:bAnimated completion:completion];
}

@end

@implementation UIViewController (margin)

- (void)setLeftBarButtonItem:(UIBarButtonItem *)item {
    self.navigationItem.leftBarButtonItem = item;
}

- (UIBarButtonItem *)leftBarButtonItem {
    return self.navigationItem.leftBarButtonItem;
}

- (void)setRightBarButtonItem:(UIBarButtonItem *)item {
    self.navigationItem.rightBarButtonItem = item;
}

- (UIBarButtonItem *)rightBarButtonItem {
    return self.navigationItem.rightBarButtonItem;
}

- (void)setLeftBarButtonItems:(NSArray *)items {
    self.navigationItem.leftBarButtonItems = items;
}

- (void)setRightBarButtonItems:(NSArray *)items {
    self.navigationItem.rightBarButtonItems = items;
}

- (UIBarButtonItem *)addLeftBarBtnItemWithName:(NSString *)btnName action:(SEL)selector {
    UIBarButtonItem *barBtnItem =
    [[UIBarButtonItem alloc] initWithTitle:btnName style:UIBarButtonItemStylePlain target:self action:selector];
    
    if (self.navigationItem.leftBarButtonItems) {
        NSMutableArray *marrBtnItems = [self.navigationItem.leftBarButtonItems mutableCopy];
        [marrBtnItems addObject:barBtnItem];
        
        self.navigationItem.leftBarButtonItems = marrBtnItems;
    }
    else {
        self.navigationItem.leftBarButtonItems = @[ barBtnItem ];
    }
    
    return barBtnItem;
}

- (UIBarButtonItem *)addRightBarBtnItemWithName:(NSString *)btnName action:(SEL)selector {
    UIBarButtonItem *barBtnItem =
    [[UIBarButtonItem alloc] initWithTitle:btnName style:UIBarButtonItemStylePlain target:self action:selector];
    
    if (self.navigationItem.rightBarButtonItems) {
        NSMutableArray *marrBtnItems = [self.navigationItem.rightBarButtonItems mutableCopy];
        [marrBtnItems addObject:barBtnItem];
        
        self.navigationItem.rightBarButtonItems = marrBtnItems;
    }
    else {
        self.navigationItem.rightBarButtonItems = @[ barBtnItem ];
    }
    
    return barBtnItem;
}

@end
