//
//  IBTUIScrollView.m
//  Cruiser
//
//  Created by Xummer on 4/13/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTUIScrollView.h"
#import "IBTInputViewHandleDelegate.h"

@implementation IBTUIScrollView

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    [super touchesBegan:touches withEvent:event];
    if (_bHandleKeyboard) {
        if ([self.m_inputHandleDelegate respondsToSelector:@selector(handleInputView:)]) {
            [self.m_inputHandleDelegate handleInputView:self];
        }
        else {
            [self.window endEditing:YES];
        }
    }
}

- (void)setContentInsetTop:(CGFloat)top andBottom:(CGFloat)bottom {
    self.contentInset = UIEdgeInsetsMake(top, 0, bottom, 0);
    self.scrollIndicatorInsets = self.contentInset;
}

@end
