
#import "AppDelegate.h"
#import "VankeFloorListBoard_iPhone.h"
#import "VankeLoginBoard_iPhone.h"
#import "VankeMainBoard_iPhone.h"
#import "VankeAppBoard_iPhone.h"
#import "VankeVersionAPI.h"
#import "GEToast.h"

@interface AppDelegate ()

@property (strong, nonatomic) NSString *upgradeUrl;//Ipa下载地址

@end

#pragma mark -

@implementation AppDelegate

- (void)load
{
    ////    [UIApplication sharedApplication].statusBarHidden = NO;
    //
    //    bee.ui.config.ASR = YES;
    //    bee.ui.config.iOS7Mode = YES;
    //    bee.ui.config.cacheAsyncLoad = YES;
    //    bee.ui.config.cacheAsyncSave = YES;
    //
    //    [BeeUITipsCenter setDefaultBubble:[UIImage imageNamed:@"alertBox.png"]];
    //    [BeeUITipsCenter setDefaultMessageIcon:[UIImage imageNamed:@"index-new-league-icon.png"]];
    //    [BeeUITipsCenter setDefaultSuccessIcon:[UIImage imageNamed:@"index-new-league-icon.png"]];
    //    [BeeUITipsCenter setDefaultFailureIcon:[UIImage imageNamed:@"index-new-league-icon.png"]];
    //
    //    [BeeUINavigationBar setBackgroundImage:[UIImage imageNamed:@"navigation-bar.png"]];
    //    [BeeUINavigationBar setTitleColor:[UIColor whiteColor]];
    //
    //    if ( [BeeSystemInfo isDevicePad] )
    //    {
    //        self.window.rootViewController = [AppBoard_iPhone sharedInstance]; // [AppBoard_iPad sharedInstance];
    //    }
    //    else
    //    {
    //        self.window.rootViewController = [AppBoard_iPhone sharedInstance];
    //    }
    //
    //
    //    [BeeUITipsCenter setDefaultContainerView:self.window.rootViewController.view];
    
    [UIApplication sharedApplication].statusBarHidden = NO;
    [[UIApplication sharedApplication]setStatusBarHidden:YES withAnimation:UIStatusBarAnimationNone];
    
    bee.ui.config.ASR = YES;
    bee.ui.config.iOS7Mode = YES;
//    bee.ui.config.highPerformance = YES;
    //  bee.ui.config.cacheAsyncLoad = YES;
    //	bee.ui.config.cacheAsyncSave = YES;
    
    [self checkNewVersion];
    
    [BeeUINavigationBar setTitleColor:[UIColor whiteColor]];
    self.window.rootViewController = [BeeUIStack stackWithFirstBoardClass:[VankeAppBoard_iPhone class]];
    //       self.window.rootViewController = [BeeUIStack stackWithFirstBoardClass:[AppBoard_iPhone class]];
}

- (void)unload
{
}

-(void) checkNewVersion {
    [VankeVersionAPI cancel];
    
    VankeVersionAPI *api = [VankeVersionAPI api];
    
    @weakify(api);
    @weakify(self);
    
    api.whenSucceed = ^{
        @normalize(api);
        @normalize(self);
       
            if (api.succeed) {
                [GEToast hideProgress];
                
                if (nil == api.serverResp) {
                    api.failed = YES;
                } else {
                    VersionResponse *resp = (VersionResponse*) api.serverResp;
                    [self performSelector:@selector(tryToUpdate:) withObject:resp];
                }
            }
    };
    
    api.whenFailed = ^{
        @normalize(api);
        @normalize(self);
        [GEToast hideProgress];
    };
    
    [GEToast showProgress:self.window];
    [api send];
}

-(void) tryToUpdate: (VersionResponse*) resp {
    VersionNumber *newVersion = [resp newVersion];
    if (nil == newVersion) {
        INFO(@"没有新版本");
    } else {
        INFO(@"发现新版本: %@", [newVersion toString]);
        self.upgradeUrl = resp.data.url;
        NSString *msg = [NSString stringWithFormat:@"发现新版本: %@, 请前往下载!", [newVersion toString]];
        
        if ([resp isForceUpdate]) {
            UIAlertView *alertV = [[UIAlertView alloc]initWithTitle:@"新版本告知" message: msg delegate:self cancelButtonTitle:nil otherButtonTitles: @"去下载", nil];
            alertV.tag = 1001;
            [alertV show];
        } else {
            UIAlertView *alertV = [[UIAlertView alloc]initWithTitle:@"新版本告知" message: msg delegate:self cancelButtonTitle:@"下次再说"otherButtonTitles: @"去下载", nil];
            alertV.tag = 1002;
            [alertV show];
        }
    }
}

- (void) alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (alertView.tag == 1001) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:self.upgradeUrl]];
    } else if (alertView.tag == 1002) {
        if (buttonIndex == 1) {
            [[UIApplication sharedApplication] openURL:[NSURL URLWithString:self.upgradeUrl]];
        } else {
            // TODO
        }
    }
}

@end
