//
//  XFFruiteHeaders.h
//  vanke
//
//  Created by Z on 16/7/12.
//  Copyright © 2016年 gomore. All rights reserved.
//

#ifndef OtherHeaders_h
#define OtherHeaders_h

#import "IBTCommon.h"

#import "UIColor+Helper.h"
#import "IBTCustomButtom.h"
#import "VankeCommonModel.h"
#import "ICRHTTPController.h"
#import "VankeConfig.h"

#define KNOTIFICATION_GetNextDetailData  @"KNOTIFICATION_GetNextDetailData"
#define KNOTIFICATION_GoReportDetail  @"KNOTIFICATION_GoReportDetail"
#define WS(weakSelf)  __weak __typeof(&*self)weakSelf = self

#define HexColor(colorStr)      [UIColor colorWithHexString:colorStr]
#define GXF_NAVIGAYION_COLOR    HexColor(@"7ebf74")
#define GXF_SAVE_COLOR          HexColor(@"50bd62")
#define GXF_COMMIT_COLOR        HexColor(@"f69100")
#define GXF_PLACEHOLDER_COLOR   HexColor(@"bbbbbb")
#define GXF_CONTENT_COLOR       HexColor(@"444444")
#define GXF_CELL_COLOR          HexColor(@"aaaaaa")
#define GXF_LINE_COLOR          HexColor(@"e5e5e5")
#define GXF_DETAIL_COLOR        HexColor(@"888888")
#define GXF_LEFTSIX_COLOR       HexColor(@"666666")

/**
 *  colors
 */
#define kSysWhite  [UIColor whiteColor]
//红 #ED1B23
#define kMainRedColor [UIColor colorWithRed:0.929 green:0.106 blue:0.137 alpha:1.000]
//蓝 #478FF1
#define kMainBlueColor [UIColor colorWithRed:0.278 green:0.561 blue:0.945 alpha:1.000]
//橙 #EA6402
#define kMainOrangeColor [UIColor colorWithRed:0.918 green:0.392 blue:0.008 alpha:1.000]
//紫 #5435AD
#define kMainPurpleColor [UIColor colorWithRed:0.329 green:0.208 blue:0.678 alpha:1.000]

//报表统一颜色
#define ReportColor                             GXF_NAVIGAYION_COLOR
#define ReportContentColor                      HexColor(@"f4422e")
#define ReportTitleColor                        GXF_PLACEHOLDER_COLOR
#define ReportBgColor                           RGBA(219,219,219,1)
#define ReportTwoColor                          HexColor(@"A3A3A3")

#define ReportChainSignPlus                     @"plus"
#define ReportChainSignMinus                    @"minus"
#define ReportChainPlusImage                    @"goSale"
#define ReportChainMinusImage                   @"downSale"

//销售
#define SaleDay                                   @"日"
#define SaleWeek                                  @"周"
#define SaleMonth                                 @"月"

#define SaleEnDay                                 @"day"
#define SaleEnWeek                                @"week"
#define SaleEnMonth                               @"month"
#define OrderLastWeak        @"比上周同期"
#define OrderLastMonth       @"比上月同期"
#define LastWeak             @"比上周"
#define LastMonth            @"比上月"
#define AvgLabelDay          @"单店日均"
#define AvgLabelWeek         @"单店周均"
#define AvgLabelMonth        @"单店月均"
#define FontSize(num)           [UIFont systemFontOfSize:num]
#define AppWindow               [[UIApplication sharedApplication].delegate window]

#define GXF_ELEVTEEN_SIZE       FontSize(11)
#define GXF_TWELVETEEN_SIZE     FontSize(12)
#define GXF_THREETEENTH_SIZE    FontSize(13)
#define GXF_FOURTEENTH_SIZE     FontSize(14)
#define GXF_FIFTEENTEN_SIZE     FontSize(15)
#define GXF_SIXTEENTEH_SIZE     FontSize(16)
#define GXF_SEVENTEENTH_SIZE    FontSize(17)

//查看报表
#define REPORT_TYPE_FLOOR @"floor" //楼层销售
#define REPORT_TYPE_BIZ @"biz"  //业态销售
/*
 * Clog
 */
#ifdef DEBUG
#define CLog(format, ...) NSLog((@"[Line %d] %s " format), __LINE__, __PRETTY_FUNCTION__, ## __VA_ARGS__)
#else
#define CLog(format, ...)
#endif

//收起键盘
#define HIDE_KEYBOARD [[UIApplication sharedApplication].keyWindow endEditing:YES]


#endif /* OtherHeaders_h */
