//
//  VankeFloorDetailWebViewController.m
//  vanke
//
//  Created by Z on 16/5/24.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "VankeFloorDetailWebViewController.h"
#import "VankeConfig.h"
#import "UIImageView+WebCache.h"
#import "VankeCommonModel.h"
#import "ScrollMultipleWebView.h"
#import <WebKit/WebKit.h>
@interface VankeFloorDetailWebViewController ()<WKNavigationDelegate>
@property (strong, nonatomic) IBOutlet UIImageView *imgViewTop;
@property (strong, nonatomic) IBOutlet UILabel *labelProjectName;
@property (weak, nonatomic) IBOutlet UILabel *labelDate;
@property (nonatomic, strong) FloorCellValue *floorValue;
@property (nonatomic, strong) NSString *strSelectDate;
@property (nonatomic, strong) ScrollMultipleWebView *webView;
@property (nonatomic, strong) UIDatePicker *datePicker;



@end

@implementation VankeFloorDetailWebViewController



- (instancetype)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil FloorValue:(FloorCellValue *)value date:(NSString *)date {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.floorValue = value;
        self.strSelectDate = date;
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    self.title = self.floorValue.project.projectClassification;
    self.labelProjectName.text = self.floorValue.project.projectName;
    NSString *imgUrl = [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_MEDIA_BASE_URL, self.floorValue.project.picture];
    [self.imgViewTop sd_setImageWithURL:[NSURL URLWithString:imgUrl] placeholderImage:[UIImage imageNamed:@"floor-def"]];
    UIBarButtonItem *btnRightBar = [[UIBarButtonItem alloc] initWithTitle:@"日期" style:UIBarButtonItemStyleDone target:self action:@selector(actionSelectDate)];
    btnRightBar.tintColor = [UIColor whiteColor];
    self.navigationItem.rightBarButtonItem = btnRightBar;
    
    [self setUpWebView];
    
}


/** 选择日期 */
- (void)actionSelectDate {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"\n\n\n\n\n\n\n\n\n\n\n" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    [alertController.view addSubview:self.datePicker];
    
    [alertController addAction:({
        UIAlertAction *action = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
            NSDateFormatter *df = [[NSDateFormatter alloc] init];
            [df setDateFormat:@"yyyy-MM-dd"];
            NSString *dateStr = [df stringFromDate:self.datePicker.date];
            
            self.strSelectDate = dateStr;
            self.labelDate.text = dateStr;
            [self.webView updateUrls:[self getUrlArr]];
        
        }];

        
        action;
    })];
    
    [alertController addAction:({
        UIAlertAction *action1 = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
        action1;
    })];
    
    UIPopoverPresentationController *popoverController = alertController.popoverPresentationController;
    popoverController.sourceView = self.view;
    popoverController.sourceRect = [self.view bounds];
    [self presentViewController:alertController  animated:YES completion:nil];
}

- (UIDatePicker *)datePicker {
    if (!_datePicker) {
        _datePicker = [[UIDatePicker alloc] init];
        _datePicker.datePickerMode = UIDatePickerModeDate;
        _datePicker.maximumDate = [NSDate date];
        _datePicker.locale = [NSLocale localeWithLocaleIdentifier:@"zh-Hans"];
        [_datePicker setDatePickerMode:UIDatePickerModeDate];
    }
    return _datePicker;
}

- (void)setUpWebView {
    [self.webView removeFromSuperview];
    self.labelDate.text = self.strSelectDate;
    
    NSArray *urls = [self getUrlArr];
    self.webView = [[ScrollMultipleWebView alloc] initWithFrame:CGRectMake(0, 190.0 + 55, SCREEN_WIDTH, SCREEN_HEIGHT - (190 + 55)) webViewUrls:urls];
    [self.view insertSubview:self.webView belowSubview:self.imgViewTop];
    
    [self.webView setPageControlBackgroundColor:nil];
}


- (NSArray *)getUrlArr {
    
    Enterpirse *ent = [[VankeCommonModel sharedInstance] currentEnt];
    //1客流销售
    NSString *passengersaleschart = [NSString stringWithFormat:@"%@/wanke-web/chart/passengersaleschart.thor?projectid=%@&passengerflowdate=%@",VANKE_SERVER_MEDIA_BASE_URL, self.floorValue.project.projectId, self.strSelectDate];
    //2业态经营
    NSString *formatdischart = [NSString stringWithFormat:@"%@/wanke-web/chart/formatdischart.thor?projectid=%@", VANKE_SERVER_MEDIA_BASE_URL,self.floorValue.project.projectId];
    //3收缴率
    NSString *url2 = [NSString stringWithFormat:@"%@/wanke-web/chart/formatratechart.thor?projectid=%@&ratedate=%@", VANKE_SERVER_MEDIA_BASE_URL,self.floorValue.project.projectId,self.strSelectDate];
    //业态销售
    NSString *sale = [NSString stringWithFormat:@"%@/wanke-web/chart/formatflowchart.thor?projectEquals=%@&salesDateEquals=%@&dimensionTypeEquals=sale&enterprise=%@", VANKE_SERVER_MEDIA_BASE_URL,self.floorValue.project.projectId,self.strSelectDate,ent.uuid];
    //楼层销售
    NSString *flow = [NSString stringWithFormat:@"%@/wanke-web/chart/formatflowchart.thor?projectEquals=%@&salesDateEquals=%@&dimensionTypeEquals=flow&enterprise=%@", VANKE_SERVER_MEDIA_BASE_URL,self.floorValue.project.projectId,self.strSelectDate, ent.uuid];
    //客流分布
    NSString *url = [NSString stringWithFormat:@"%@/wanke-web/chart/formatpaschart.thor?projectEquals=%@&passengerFlowDateEquals=%@&enterprise=%@", VANKE_SERVER_MEDIA_BASE_URL,self.floorValue.project.projectId,self.strSelectDate,ent.uuid];
    CLog(@"%@", @[passengersaleschart, formatdischart, url2, sale, flow, url]);
    return @[formatdischart, passengersaleschart, url2, sale, flow, url];
}

- (void)viewDidLayoutSubviews {
//    self.imgViewTop.frame = CGRectMake(0, 64, SCREEN_WIDTH, 220.0 * (SCREEN_WIDTH / 375.0));
    

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
