//
//  ReportBoardsViewController.m
//  vanke
//
//  Created by Z on 16/7/15.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "ReportBoardsViewController.h"
#import "ReportBoardTableViewCell.h"
#import "ReportViewController.h"
#import "VankeAppBoard_iPhone.h"
static NSString *const cellId = @"cellId";

@interface ReportBoardsViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *arrTitles;
@property (nonatomic, strong) NSArray *arrPicName;
@end
@implementation ReportBoardsViewController

ON_CREATE_VIEWS( signal )
{
    self.navigationBarShown = YES;
    self.navigationBarTitle = @"报表";
    self.navigationBarLeft  = nil;
    
    UIColor *color = [UIColor colorWithR:63 g:134 b:244 a:1];
    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
    } else {
        self.navigationController.navigationBar.tintColor = color;
    }
    
    
    
}

ON_DID_APPEAR( signal )
{
    self.arrTitles = @[@"楼层销售报表",@"业态销售报表"];
    self.arrPicName = @[@"楼层销售",@"业态销售"];
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 64, SCREEN_WIDTH, SCREEN_HEIGHT - 64 - 49) style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerNib:[UINib nibWithNibName:@"ReportBoardTableViewCell" bundle:nil] forCellReuseIdentifier:cellId];
    [self.view addSubview:self.tableView];

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[VankeAppBoard_iPhone sharedInstance] showMenu];

}


#pragma mark - tableView delegate

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 90;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    ReportViewController *reportVC = [[ReportViewController alloc] init];
    
    switch (indexPath.row) {
        case 0:
        {
            reportVC.title = @"楼层销售报表";
            reportVC.reportType = REPORT_TYPE_FLOOR;
        }
            break;
        case 1:
        {
            reportVC.title = @"业态销售报表";
            reportVC.reportType = REPORT_TYPE_BIZ;
        }
            break;
            
            
        default:
            break;
    }
    [self.navigationController pushViewController:reportVC animated:YES];

}

#pragma mark - tableView dataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.arrTitles.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    ReportBoardTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellId forIndexPath:indexPath];
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    cell.img.image = [UIImage imageNamed:self.arrPicName[indexPath.row]];
    cell.labelTItle.text = self.arrTitles[indexPath.row];
    return cell;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
