//
//  RSaleView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/13.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RSaleView.h"
#import "CalculateHelper.h"
//#import "SMPageControl.h"
#define LeftWidth   50
#define ImageSize 20
#define ContentHeight 25
#define CenImageSize 40

@interface RSaleView ()
@property (nonatomic,strong)UILabel *centerLabel;
@property (nonatomic,strong)UILabel *dateLabel;
@property (nonatomic,strong)UIButton *lastWeekLabel;
@property (nonatomic,strong)UIButton *lastYearLabel;
@property (nonatomic,strong)UILabel *rateLabel;
@property (nonatomic,strong)UILabel *averageLabel;
@property (nonatomic,strong)UIImageView *lastWeekImage;
@property (nonatomic,strong)UIImageView *lastYearImage;
//@property (nonatomic,strong)SMPageControl *pageControl;
@property (nonatomic,assign)NSInteger currentPage;


@end



@implementation RSaleView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
        self.currentPage = 0;
    }
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame withPage:(NSInteger)currentPage{
    self = [super initWithFrame:frame];
    if (self) {
        self.currentPage = currentPage;
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout{
    
    self.bgImage = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, self.width, self.height)];
    [self addSubview:self.bgImage];
    
    self.cenImage = [[UIImageView alloc]initWithFrame:CGRectMake(self.width/4, 20, CenImageSize, CenImageSize)];
    self.cenImage.contentMode = UIViewContentModeScaleAspectFit;
    [self addSubview:self.cenImage];
    
    
    self.centerLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.cenImage.right+5, 20, SCREEN_WIDTH - self.cenImage.right, ContentHeight)];
    self.centerLabel.textColor = ReportContentColor;
    self.centerLabel.font = FontSize(28);
    [self addSubview:self.centerLabel];

    

    self.dateLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.centerLabel.left, self.centerLabel.bottom,self.width-self.centerLabel.left, ContentHeight)];
    self.dateLabel.textColor = [UIColor lightGrayColor];
    self.dateLabel.font =  GXF_THREETEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentLeft;
    [self addSubview:self.dateLabel];
    
    CGFloat bottomWidth = (SCREEN_WIDTH - 20)/3;
    
    self.lastWeekLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:CGRectMake(10, self.dateLabel.bottom + 5,bottomWidth, ContentHeight) fontSize:15 fontColor:[UIColor lightGrayColor]];
    [self addSubview:self.lastWeekLabel];
    

    UILabel *weekLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.lastWeekLabel.left, self.lastWeekLabel.bottom,bottomWidth,20)];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周同期";
    weekLabel.font = GXF_THREETEENTH_SIZE;
    weekLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:weekLabel];
    self.weekLabel = weekLabel;
    

     self.lastYearLabel = [IBTCommon buttonWithTitle:@"" Image:nil frame:CGRectMake(self.lastWeekLabel.right, self.lastWeekLabel.top,bottomWidth, ContentHeight) fontSize:15 fontColor:[UIColor lightGrayColor]];
    [self addSubview:self.lastYearLabel];

    

    UILabel *yearLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.lastYearLabel.left, self.lastWeekLabel.bottom,bottomWidth,20)];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.text = @"比去年同期";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    yearLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:yearLabel];
    

    self.rateLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.lastYearLabel.right,self.lastWeekLabel.top,bottomWidth, ContentHeight)];
    self.rateLabel.textColor = GXF_COMMIT_COLOR;
    self.rateLabel.font =  GXF_FIFTEENTEN_SIZE;

    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:self.rateLabel];
    

    UILabel *raLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.rateLabel.left, self.lastWeekLabel.bottom,bottomWidth,20)];
    raLabel.textColor = [UIColor lightGrayColor];
    raLabel.text = @"日均坪效";
    raLabel.font = GXF_THREETEENTH_SIZE;
    raLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:raLabel];
    

//    self.averageLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.rateLabel.right, self.lastWeekLabel.top,bottomWidth, ContentHeight)];
//    self.averageLabel.textColor = GXF_COMMIT_COLOR;
//    self.averageLabel.font =  GXF_FIFTEENTEN_SIZE;
//
//    self.averageLabel.textAlignment = NSTextAlignmentCenter;
//    [self addSubview:self.averageLabel];
//    
//
//    UILabel *avLabel = [[UILabel alloc]initWithFrame:CGRectMake(self.averageLabel.left, self.lastWeekLabel.bottom,bottomWidth,20)];
//    avLabel.textColor = [UIColor lightGrayColor];
//    avLabel.text = @"单店日均";
//    avLabel.font = GXF_THREETEENTH_SIZE;
//    avLabel.textAlignment = NSTextAlignmentCenter;
//    [self addSubview:avLabel];
//    self.avgLabel = avLabel;
//    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, avLabel.bottom+5, SCREEN_WIDTH, 10)];
//    self.pageControl.numberOfPages = 4;
//    self.pageControl.currentPage = self.currentPage;
//    self.pageControl.pageIndicatorImage = [UIImage imageNamed:@"white_point"];
//    self.pageControl.currentPageIndicatorImage = [UIImage imageNamed:@"yellow_point"];
//    self.pageControl.indicatorMargin = 5.0f;
//    self.pageControl.indicatorDiameter = 10.0f;
//    [self addSubview:self.pageControl];
}
- (void)setWeekLabelStr:(NSString *)weekLabelStr{
    
    NSString *typeStr = @"";
    NSString *avStr = @"";
    if ([weekLabelStr isEqualToString:SaleEnDay]) {
        typeStr = OrderLastWeak;
        avStr = AvgLabelDay;
    }else if([weekLabelStr isEqualToString:SaleEnWeek]){
        typeStr = OrderLastWeak;
        avStr = AvgLabelWeek;
    }else if([weekLabelStr isEqualToString:SaleEnMonth]){
        typeStr = OrderLastMonth;
        avStr = AvgLabelMonth;
    }
    self.weekLabel.text = typeStr;
    self.avgLabel.text = avStr;
}
- (void)setValueInSaleView:(Compass *)compass{
    //统计时间
    NSString *weekday = @"";
    if ([IBTCommon convertToDateFrom:compass.dataScope]) {
        weekday = [IBTCommon weekdayStringFromDate:[IBTCommon convertToDateFrom:compass.dataScope]];
    }
   
    self.dateLabel.text = [NSString stringWithFormat:@"%@累计销售额",compass.dataScope];
    
    //销售额
    NSString *strSales = [CalculateHelper getMoneyStringFrom:compass.sales Lenth:0 isSeparate:YES];
     self.centerLabel.text = compass.sales?strSales :@"---";

    //销售环比变化率 比上周
    NSDecimalNumber *saleDifference = [CalculateHelper calculateNum1:compass.sales num2:compass.salesChain type:CalculateTypeSub roundingType:NSRoundBankers cutLenth:4];
    NSDecimalNumber *decimalSaleRate = [CalculateHelper calculateNum1:saleDifference num2:compass.salesChain type:CalculateTypeDiv roundingType:NSRoundBankers cutLenth:4];
    decimalSaleRate = [CalculateHelper oneHundredTimes:decimalSaleRate];
    NSString *salesChainRateStr = decimalSaleRate?[NSString stringWithFormat:@"%@%%", [CalculateHelper getMoneyStringFromString:[decimalSaleRate stringValue]]]:@"---";
    if (!compass) {
        salesChainRateStr = @"---";
    }
    
    if ([compass.salesChain isEqualToNumber:@0]) {
        salesChainRateStr = @"---";
    }
    
    if (![salesChainRateStr hasPrefix:@"-"] && ![salesChainRateStr isEqualToString:@"0"] && ![salesChainRateStr hasPrefix:@"--"]) {
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
        self.centerLabel.textColor = ReportContentColor;
        [self.lastWeekLabel setTitleColor:ReportContentColor forState:UIControlStateNormal];
    }else if ([salesChainRateStr hasPrefix:@"-"] && ![salesChainRateStr isEqualToString:@"0"] && ![salesChainRateStr hasPrefix:@"--"]){
        [self.lastWeekLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
        self.centerLabel.textColor = GXF_SAVE_COLOR;
        [self.lastWeekLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateNormal];
    }else{
        [self.lastWeekLabel setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
        [self.lastWeekLabel setImage:nil forState:UIControlStateNormal];
        self.centerLabel.textColor = [UIColor lightGrayColor];
    }
    [self.lastWeekLabel setTitle:[CalculateHelper getABSValue:salesChainRateStr] forState:UIControlStateNormal];
    
    //销售同比变化率 比上年
    NSDecimalNumber *decimalSalesYoYDifference = [CalculateHelper calculateNum1:compass.sales num2:compass.salesYoY type:CalculateTypeSub roundingType:NSRoundBankers cutLenth:4];
    NSDecimalNumber *decimalSalesYoY = [CalculateHelper calculateNum1:decimalSalesYoYDifference num2:compass.salesYoY type:CalculateTypeDiv roundingType:NSRoundBankers cutLenth:4];
    decimalSalesYoY = [CalculateHelper oneHundredTimes:decimalSalesYoY];
    
    NSString *salesYoStr = decimalSalesYoY?[NSString stringWithFormat:@"%@%%",[decimalSalesYoY stringValue ]]:@"---";
    if ([compass.salesYoY isEqualToNumber:@0]) {
        salesYoStr = @"---";
    }
    
    if (!compass) {
        salesYoStr = @"---";
    }
    if (![salesYoStr hasPrefix:@"-"] && ![salesYoStr isEqualToString:@"0"] && ![salesYoStr hasPrefix:@"--"]) {
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainPlusImage] forState:UIControlStateNormal];
         [self.lastYearLabel setTitleColor:ReportContentColor forState:UIControlStateNormal];
    }else if ([salesYoStr hasPrefix:@"-"] && ![salesYoStr isEqualToString:@"0"] && ![salesYoStr hasPrefix:@"--"]){
        [self.lastYearLabel setImage:[UIImage imageNamed:ReportChainMinusImage] forState:UIControlStateNormal];
         [self.lastYearLabel setTitleColor:GXF_SAVE_COLOR forState:UIControlStateNormal];
    }else{
        [self.lastYearLabel setImage:nil forState:UIControlStateNormal];
        [self.lastYearLabel setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
    }
    
    [self.lastYearLabel setTitle:[CalculateHelper getABSValue:salesYoStr] forState:UIControlStateNormal];
    //坪效
    
    NSDecimalNumber *groundEffect = [CalculateHelper calculateNum1:compass.sales num2:compass.area type:CalculateTypeDiv roundingType:NSRoundBankers cutLenth:2];
    NSString *salesTargetStr = compass.area?[NSString stringWithFormat:@"%@",[CalculateHelper getMoneyStringFrom:groundEffect]]:@"---";
    self.rateLabel.text = salesTargetStr;
//    //单店日均销售
//    NSString *dailysalesPerStr = compass.dailysalesPerStore?[NSString stringWithFormat:@"%@",[IBTCommon stringDisposeWithFloat:[compass.dailysalesPerStore floatValue]]]:@"---";
//    self.averageLabel.text = dailysalesPerStr;
    
}

@end
