//
//  ICRHelpAndFeedBackViewController.m
//  Cruiser
//
//  Created by Lili Wang on 15/4/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define LABEL_LEFT_PANDING    (20)
#define SUBMIT_BUTTON_HEIGHT  (44)
#define GRAY_LINE_WIDTH       (0.5)
#define TEXTVIEW_TOP_PANDING  (10)
#define TEXTVIEW_HEIGHT       (120)

#import "ICRHelpAndFeedBackViewController.h"
#import "ICRPlaceholderTextView.h"
#import "ICRAppMacro.h"
#import "VankeUtil.h"

@interface ICRHelpAndFeedBackViewController ()

@property (nonatomic, assign) BOOL initialized;

@end

@implementation ICRHelpAndFeedBackViewController

ON_CREATE_VIEWS( signal )
{
    self.initialized = NO;
    self.title = [IBTCommon localizableString:@"Feedback"];
    self.view.backgroundColor = [VankeUtil colorWithHexString:@"#f6f6f6"];
}

ON_LAYOUT_VIEWS( signal )
{
    if (!self.initialized) {
        [self setupSubviews];
        self.initialized = YES;
    }
}

#pragma mark - Life Cycle
//- (void)viewDidLoad {
//    [super viewDidLoad];
//    // Do any additional setup after loading the view.
//    [self setupSubviews];
//}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

#pragma mark - Private Method
- (void)setupSubviews {
    UILabel *label = [[UILabel alloc] initWithFrame:(CGRect){
        .origin.x = LABEL_LEFT_PANDING,
        .origin.y = LABEL_LEFT_PANDING,
        .size.width = self.view.width - LABEL_LEFT_PANDING * 2,
        .size.height = SUBMIT_BUTTON_HEIGHT
    }];
    label.backgroundColor = [UIColor clearColor];
    label.font = [UIFont systemFontOfSize:16.0f];
    label.textColor = [UIColor colorWithW:109 a:1];
    label.textAlignment = NSTextAlignmentLeft;
    label.text = [IBTCommon localizableString:@"Fill In The Comments:"];
    [self.view addSubview:label];
    
    CGFloat fDx = LABEL_LEFT_PANDING - 4;
    UIView *contentView = [[UIView alloc] initWithFrame:(CGRect){
        .origin.x = fDx,
        .origin.y = label.bottom + TEXTVIEW_TOP_PANDING,
        .size.width = self.view.width - fDx * 2,
        .size.height = TEXTVIEW_HEIGHT
    }];
    contentView.layer.masksToBounds = YES;
    contentView.layer.cornerRadius = 5;
    contentView.backgroundColor = [UIColor lightGrayColor];
    
    ICRPlaceholderTextView *placeView = [[ICRPlaceholderTextView alloc] initWithFrame:(CGRect){
        .origin.x = GRAY_LINE_WIDTH,
        .origin.y = GRAY_LINE_WIDTH,
        .size.width = contentView.width - GRAY_LINE_WIDTH * 2,
        .size.height = contentView.height - GRAY_LINE_WIDTH * 2
    }];
    placeView.layer.masksToBounds = YES;
    placeView.layer.cornerRadius = 5;
    placeView.font = [UIFont systemFontOfSize:16.0f];
    placeView.m_placeHolder = [IBTCommon localizableString:@"Please Enter Your Comments"];
    placeView.m_placeholderColor = [UIColor colorWithW:109 a:1];
    
    [contentView addSubview:placeView];
    [self.view addSubview:contentView];
    
    UIButton *button =
    [IBTCustomButtom buttonWithTitle:[IBTCommon localizableString:@"Submit Feedback"]
                               color:ICR_ORANGE_BTN_COLOR target:self action:@selector(onSubmit:)];
    button.frame = (CGRect){
        .origin.x = LABEL_LEFT_PANDING,
        .origin.y = contentView.bottom + 20.0f,
        .size.width = self.view.width - LABEL_LEFT_PANDING * 2,
        .size.height = SUBMIT_BUTTON_HEIGHT
    };
    [button.layer setCornerRadius:5.0]; //设置矩形四个圆角半径
    button.autoresizingMask = UIViewAutoresizingFlexibleTopMargin;
        [self.view addSubview:button];
    
}

#pragma mark - Actions 
- (void)onSubmit:(__unused id)sender {
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.6 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [IBTLoadingView showTips:@"反馈成功！"];
        [self.navigationController popViewControllerAnimated:YES];
    });
}

@end
