//
//  StatementDetailItems.m
//
//  Created by 杰 张 on 16/7/18
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "StatementDetailItems.h"


NSString *const kStatementDetailItemsAmount = @"amount";
NSString *const kStatementDetailItemsRemark = @"remark";
NSString *const kStatementDetailItemsEndDate = @"endDate";
NSString *const kStatementDetailItemsUnpaid = @"unpaid";
NSString *const kStatementDetailItemsSubject = @"subject";
NSString *const kStatementDetailItemsBeginDate = @"beginDate";
NSString *const kStatementDetailItemsDirection = @"direction";
NSString *const kStatementDetailItemsPaid = @"paid";


@interface StatementDetailItems ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation StatementDetailItems

@synthesize amount = _amount;
@synthesize remark = _remark;
@synthesize endDate = _endDate;
@synthesize unpaid = _unpaid;
@synthesize subject = _subject;
@synthesize beginDate = _beginDate;
@synthesize direction = _direction;
@synthesize paid = _paid;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.amount = [[self objectOrNilForKey:kStatementDetailItemsAmount fromDictionary:dict] doubleValue];
            self.remark = [self objectOrNilForKey:kStatementDetailItemsRemark fromDictionary:dict];
            self.endDate = [self objectOrNilForKey:kStatementDetailItemsEndDate fromDictionary:dict];
            self.unpaid = [[self objectOrNilForKey:kStatementDetailItemsUnpaid fromDictionary:dict] doubleValue];
            self.subject = [self objectOrNilForKey:kStatementDetailItemsSubject fromDictionary:dict];
            self.beginDate = [self objectOrNilForKey:kStatementDetailItemsBeginDate fromDictionary:dict];
            self.direction = [[self objectOrNilForKey:kStatementDetailItemsDirection fromDictionary:dict] doubleValue];
            self.paid = [[self objectOrNilForKey:kStatementDetailItemsPaid fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.amount] forKey:kStatementDetailItemsAmount];
    [mutableDict setValue:self.remark forKey:kStatementDetailItemsRemark];
    [mutableDict setValue:self.endDate forKey:kStatementDetailItemsEndDate];
    [mutableDict setValue:[NSNumber numberWithDouble:self.unpaid] forKey:kStatementDetailItemsUnpaid];
    [mutableDict setValue:self.subject forKey:kStatementDetailItemsSubject];
    [mutableDict setValue:self.beginDate forKey:kStatementDetailItemsBeginDate];
    [mutableDict setValue:[NSNumber numberWithDouble:self.direction] forKey:kStatementDetailItemsDirection];
    [mutableDict setValue:[NSNumber numberWithDouble:self.paid] forKey:kStatementDetailItemsPaid];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.amount = [aDecoder decodeDoubleForKey:kStatementDetailItemsAmount];
    self.remark = [aDecoder decodeObjectForKey:kStatementDetailItemsRemark];
    self.endDate = [aDecoder decodeObjectForKey:kStatementDetailItemsEndDate];
    self.unpaid = [aDecoder decodeDoubleForKey:kStatementDetailItemsUnpaid];
    self.subject = [aDecoder decodeObjectForKey:kStatementDetailItemsSubject];
    self.beginDate = [aDecoder decodeObjectForKey:kStatementDetailItemsBeginDate];
    self.direction = [aDecoder decodeDoubleForKey:kStatementDetailItemsDirection];
    self.paid = [aDecoder decodeDoubleForKey:kStatementDetailItemsPaid];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_amount forKey:kStatementDetailItemsAmount];
    [aCoder encodeObject:_remark forKey:kStatementDetailItemsRemark];
    [aCoder encodeObject:_endDate forKey:kStatementDetailItemsEndDate];
    [aCoder encodeDouble:_unpaid forKey:kStatementDetailItemsUnpaid];
    [aCoder encodeObject:_subject forKey:kStatementDetailItemsSubject];
    [aCoder encodeObject:_beginDate forKey:kStatementDetailItemsBeginDate];
    [aCoder encodeDouble:_direction forKey:kStatementDetailItemsDirection];
    [aCoder encodeDouble:_paid forKey:kStatementDetailItemsPaid];
}

- (id)copyWithZone:(NSZone *)zone
{
    StatementDetailItems *copy = [[StatementDetailItems alloc] init];
    
    if (copy) {

        copy.amount = self.amount;
        copy.remark = [self.remark copyWithZone:zone];
        copy.endDate = [self.endDate copyWithZone:zone];
        copy.unpaid = self.unpaid;
        copy.subject = [self.subject copyWithZone:zone];
        copy.beginDate = [self.beginDate copyWithZone:zone];
        copy.direction = self.direction;
        copy.paid = self.paid;
    }
    
    return copy;
}


@end
