//
//  StatementDetailModel.m
//
//  Created by 杰 张 on 16/7/18
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "StatementDetailModel.h"
#import "StatementDetailItems.h"


NSString *const kStatementDetailModelAmount = @"amount";
NSString *const kStatementDetailModelSettle = @"settle";
NSString *const kStatementDetailModelUnpaid = @"unpaid";
NSString *const kStatementDetailModelPicture = @"picture";
NSString *const kStatementDetailModelContract = @"contract";
NSString *const kStatementDetailModelShopName = @"shopName";
NSString *const kStatementDetailModelShopCode = @"shopCode";
NSString *const kStatementDetailModelPaid = @"paid";
NSString *const kStatementDetailModelState = @"state";
NSString *const kStatementDetailModelItems = @"items";


@interface StatementDetailModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation StatementDetailModel

@synthesize amount = _amount;
@synthesize settle = _settle;
@synthesize unpaid = _unpaid;
@synthesize picture = _picture;
@synthesize contract = _contract;
@synthesize shopName = _shopName;
@synthesize shopCode = _shopCode;
@synthesize paid = _paid;
@synthesize state = _state;
@synthesize items = _items;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.amount = [[self objectOrNilForKey:kStatementDetailModelAmount fromDictionary:dict] doubleValue];
            self.settle = [self objectOrNilForKey:kStatementDetailModelSettle fromDictionary:dict];
            self.unpaid = [[self objectOrNilForKey:kStatementDetailModelUnpaid fromDictionary:dict] doubleValue];
            self.picture = [self objectOrNilForKey:kStatementDetailModelPicture fromDictionary:dict];
            self.contract = [self objectOrNilForKey:kStatementDetailModelContract fromDictionary:dict];
            self.shopName = [self objectOrNilForKey:kStatementDetailModelShopName fromDictionary:dict];
            self.shopCode = [self objectOrNilForKey:kStatementDetailModelShopCode fromDictionary:dict];
            self.paid = [[self objectOrNilForKey:kStatementDetailModelPaid fromDictionary:dict] doubleValue];
            self.state = [self objectOrNilForKey:kStatementDetailModelState fromDictionary:dict];
    NSObject *receivedStatementDetailItems = [dict objectForKey:kStatementDetailModelItems];
    NSMutableArray *parsedStatementDetailItems = [NSMutableArray array];
    if ([receivedStatementDetailItems isKindOfClass:[NSArray class]]) {
        for (NSDictionary *item in (NSArray *)receivedStatementDetailItems) {
            if ([item isKindOfClass:[NSDictionary class]]) {
                [parsedStatementDetailItems addObject:[StatementDetailItems modelObjectWithDictionary:item]];
            }
       }
    } else if ([receivedStatementDetailItems isKindOfClass:[NSDictionary class]]) {
       [parsedStatementDetailItems addObject:[StatementDetailItems modelObjectWithDictionary:(NSDictionary *)receivedStatementDetailItems]];
    }

    self.items = [NSArray arrayWithArray:parsedStatementDetailItems];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithDouble:self.amount] forKey:kStatementDetailModelAmount];
    [mutableDict setValue:self.settle forKey:kStatementDetailModelSettle];
    [mutableDict setValue:[NSNumber numberWithDouble:self.unpaid] forKey:kStatementDetailModelUnpaid];
    [mutableDict setValue:self.picture forKey:kStatementDetailModelPicture];
    [mutableDict setValue:self.contract forKey:kStatementDetailModelContract];
    [mutableDict setValue:self.shopName forKey:kStatementDetailModelShopName];
    [mutableDict setValue:self.shopCode forKey:kStatementDetailModelShopCode];
    [mutableDict setValue:[NSNumber numberWithDouble:self.paid] forKey:kStatementDetailModelPaid];
    [mutableDict setValue:self.state forKey:kStatementDetailModelState];
    NSMutableArray *tempArrayForItems = [NSMutableArray array];
    for (NSObject *subArrayObject in self.items) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForItems addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForItems addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForItems] forKey:kStatementDetailModelItems];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.amount = [aDecoder decodeDoubleForKey:kStatementDetailModelAmount];
    self.settle = [aDecoder decodeObjectForKey:kStatementDetailModelSettle];
    self.unpaid = [aDecoder decodeDoubleForKey:kStatementDetailModelUnpaid];
    self.picture = [aDecoder decodeObjectForKey:kStatementDetailModelPicture];
    self.contract = [aDecoder decodeObjectForKey:kStatementDetailModelContract];
    self.shopName = [aDecoder decodeObjectForKey:kStatementDetailModelShopName];
    self.shopCode = [aDecoder decodeObjectForKey:kStatementDetailModelShopCode];
    self.paid = [aDecoder decodeDoubleForKey:kStatementDetailModelPaid];
    self.state = [aDecoder decodeObjectForKey:kStatementDetailModelState];
    self.items = [aDecoder decodeObjectForKey:kStatementDetailModelItems];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeDouble:_amount forKey:kStatementDetailModelAmount];
    [aCoder encodeObject:_settle forKey:kStatementDetailModelSettle];
    [aCoder encodeDouble:_unpaid forKey:kStatementDetailModelUnpaid];
    [aCoder encodeObject:_picture forKey:kStatementDetailModelPicture];
    [aCoder encodeObject:_contract forKey:kStatementDetailModelContract];
    [aCoder encodeObject:_shopName forKey:kStatementDetailModelShopName];
    [aCoder encodeObject:_shopCode forKey:kStatementDetailModelShopCode];
    [aCoder encodeDouble:_paid forKey:kStatementDetailModelPaid];
    [aCoder encodeObject:_state forKey:kStatementDetailModelState];
    [aCoder encodeObject:_items forKey:kStatementDetailModelItems];
}

- (id)copyWithZone:(NSZone *)zone
{
    StatementDetailModel *copy = [[StatementDetailModel alloc] init];
    
    if (copy) {

        copy.amount = self.amount;
        copy.settle = [self.settle copyWithZone:zone];
        copy.unpaid = self.unpaid;
        copy.picture = [self.picture copyWithZone:zone];
        copy.contract = [self.contract copyWithZone:zone];
        copy.shopName = [self.shopName copyWithZone:zone];
        copy.shopCode = [self.shopCode copyWithZone:zone];
        copy.paid = self.paid;
        copy.state = [self.state copyWithZone:zone];
        copy.items = [self.items copyWithZone:zone];
    }
    
    return copy;
}


@end
