//
//  StatementModel.m
//
//  Created by 杰 张 on 16/7/18
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "StatementModel.h"
#import "StatementRecords.h"
#import "StatementPaging.h"


NSString *const kStatementModelRecords = @"records";
NSString *const kStatementModelAmount = @"amount";
NSString *const kStatementModelUnpaidTotal = @"unpaidTotal";
NSString *const kStatementModelPaidTotal = @"paidTotal";
NSString *const kStatementModelPaging = @"paging";


@interface StatementModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation StatementModel

@synthesize records = _records;
@synthesize amount = _amount;
@synthesize unpaidTotal = _unpaidTotal;
@synthesize paidTotal = _paidTotal;
@synthesize paging = _paging;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
    NSObject *receivedStatementRecords = [dict objectForKey:kStatementModelRecords];
    NSMutableArray *parsedStatementRecords = [NSMutableArray array];
    if ([receivedStatementRecords isKindOfClass:[NSArray class]]) {
        for (NSDictionary *item in (NSArray *)receivedStatementRecords) {
            if ([item isKindOfClass:[NSDictionary class]]) {
                [parsedStatementRecords addObject:[StatementRecords modelObjectWithDictionary:item]];
            }
       }
    } else if ([receivedStatementRecords isKindOfClass:[NSDictionary class]]) {
       [parsedStatementRecords addObject:[StatementRecords modelObjectWithDictionary:(NSDictionary *)receivedStatementRecords]];
    }

    self.records = [NSArray arrayWithArray:parsedStatementRecords];
            self.amount = [[self objectOrNilForKey:kStatementModelAmount fromDictionary:dict] doubleValue];
            self.unpaidTotal = [[self objectOrNilForKey:kStatementModelUnpaidTotal fromDictionary:dict] doubleValue];
            self.paidTotal = [[self objectOrNilForKey:kStatementModelPaidTotal fromDictionary:dict] doubleValue];
            self.paging = [StatementPaging modelObjectWithDictionary:[dict objectForKey:kStatementModelPaging]];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    NSMutableArray *tempArrayForRecords = [NSMutableArray array];
    for (NSObject *subArrayObject in self.records) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForRecords addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForRecords addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForRecords] forKey:kStatementModelRecords];
    [mutableDict setValue:[NSNumber numberWithDouble:self.amount] forKey:kStatementModelAmount];
    [mutableDict setValue:[NSNumber numberWithDouble:self.unpaidTotal] forKey:kStatementModelUnpaidTotal];
    [mutableDict setValue:[NSNumber numberWithDouble:self.paidTotal] forKey:kStatementModelPaidTotal];
    [mutableDict setValue:[self.paging dictionaryRepresentation] forKey:kStatementModelPaging];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.records = [aDecoder decodeObjectForKey:kStatementModelRecords];
    self.amount = [aDecoder decodeDoubleForKey:kStatementModelAmount];
    self.unpaidTotal = [aDecoder decodeDoubleForKey:kStatementModelUnpaidTotal];
    self.paidTotal = [aDecoder decodeDoubleForKey:kStatementModelPaidTotal];
    self.paging = [aDecoder decodeObjectForKey:kStatementModelPaging];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_records forKey:kStatementModelRecords];
    [aCoder encodeDouble:_amount forKey:kStatementModelAmount];
    [aCoder encodeDouble:_unpaidTotal forKey:kStatementModelUnpaidTotal];
    [aCoder encodeDouble:_paidTotal forKey:kStatementModelPaidTotal];
    [aCoder encodeObject:_paging forKey:kStatementModelPaging];
}

- (id)copyWithZone:(NSZone *)zone
{
    StatementModel *copy = [[StatementModel alloc] init];
    
    if (copy) {

        copy.records = [self.records copyWithZone:zone];
        copy.amount = self.amount;
        copy.unpaidTotal = self.unpaidTotal;
        copy.paidTotal = self.paidTotal;
        copy.paging = [self.paging copyWithZone:zone];
    }
    
    return copy;
}


@end
