//
//  StatementDetailCell.m
//  RealEstateManagement
//
//  Created by Z on 16/6/29.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "StatementDetailCell.h"
#import "StatementDetailItems.h"
#import "CalculateHelper.h"
@interface StatementDetailCell ()
/** 标题 */
@property (weak, nonatomic) IBOutlet UILabel *labelTitle;
/** 时间 */
@property (weak, nonatomic) IBOutlet UILabel *labelDate;

/** 应缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelShouldPay;
/** 已缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelPaidIn;
/** 未缴 */
@property (weak, nonatomic) IBOutlet UILabel *labelUnPaid;
@property (weak, nonatomic) IBOutlet UIImageView *img;

@end
@implementation StatementDetailCell

- (void)awakeFromNib {
    // Initialization code
}

- (void)setUpCellWithModelArray:(NSArray *)array index:(NSIndexPath *)indexPath {
    StatementDetailItems *item = array[indexPath.row];
    self.labelTitle.text = item.subject;
    self.labelDate.text = [NSString stringWithFormat:@"%@~%@",item.beginDate,item.endDate];
    self.labelShouldPay.text = [NSString stringWithFormat:@"%@元",[CalculateHelper getMoneyStringFrom:[NSNumber numberWithDouble:item.amount] Lenth:2 isSeparate:YES]];
    self.labelPaidIn.text = [NSString stringWithFormat:@"[已缴]%@元",[CalculateHelper getMoneyStringFrom:[NSNumber numberWithDouble:item.paid] Lenth:2 isSeparate:YES]];
    self.labelUnPaid.text = [NSString stringWithFormat:@"[未缴]%@元",[CalculateHelper getMoneyStringFrom:[NSNumber numberWithDouble:item.unpaid] Lenth:2 isSeparate:YES]];
    if (item.direction < 0) {
        self.img.image = [UIImage imageNamed:@"money_reduce"];
    }else{
        self.img.image = [UIImage imageNamed:@"money_add"];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
