//
//  VankePassengerFlowAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/9.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankePassengerFlowAPI.h"
#import "VankeUtil.h"
#import "PNChart.h"

#pragma VankePassengerFlowAPI

@implementation VankePassengerFlowAPI

@synthesize projectEquals;
@synthesize passengerFlowDateEquals;


-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        [self http_get:@"/passenger/querypassenger"].PARAM(@"passengerFlowDateEquals", self.passengerFlowDateEquals).PARAM(@"projectEquals", self.projectEquals).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [PassengerFlowResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.projectEquals]) {
        [self setClientError: @"项目标识不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.passengerFlowDateEquals]) {
        [self setClientError: @"客流日期不能为空"];
        return NO;
    }
    
    return YES;
}

@end


#pragma PassengerFlow

@implementation PassengerFlow

@synthesize projectId;
@synthesize projectName;
@synthesize passengerFlowDate;
@synthesize passengerFlowVolume;
@synthesize passengerFlowPosition;

@end

#pragma PassengerFlowResponse


@implementation PassengerFlowResponse

CONVERT_PROPERTY_CLASS(data, PassengerFlow)

@synthesize data = _data;

-(int) dataCount {
    if (nil == _data) {
        return 0;
    } else {
        return [_data count];
    }
}

-(NSArray*) getChartValues {
    NSMutableArray *items = [[NSMutableArray alloc] init];
    
    if (nil == self.data) {
        return items;
    }
    
    for (NSInteger i = 0; i < [_data count]; ++i) {
        PassengerFlow *obj = [_data objectAtIndex:i];
        PNPieChartDataItem *item = [PNPieChartDataItem new];
        item.value = [obj.passengerFlowVolume floatValue];
        item.textDescription = obj.passengerFlowPosition;
        [items addObject: item];
    }
    return items;
}

@end



