
//
//  VankeCommonModel.m
//  vanke
//
//  Created by xiaomi on 15/10/7.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeCommonModel.h"
#import "VankeConfig.h"

#pragma mark -

@implementation VankeCommonModel

DEF_SINGLETON(VankeCommonModel)

- (void) saveLoginUser: (User*) user password: (NSString*) password enterprise: (Enterpirse*) enterprise {
    if (nil != user) {
        [self userDefaultsWrite:[user objectToDictionary] forKey:KEY_CURRENT_USER];
    }
    
    if (nil != enterprise) {
        [self userDefaultsWrite:[enterprise objectToDictionary] forKey:KEY_CURRENT_ENT];
    }
    
    [self keychainWrite:password forKey:KEY_CURRENT_USER_PWD];
}

- (User*) currentUser {
    NSDictionary *dict = [self userDefaultsRead:KEY_CURRENT_USER];
    if (nil == dict) {
        return nil;
    }
    
    return [User objectFromDictionary: dict];
}

- (Enterpirse*) currentEnterprise {
    NSDictionary *dict = [self userDefaultsRead:KEY_CURRENT_ENT];
    if (nil == dict) {
        return nil;
    }
    
    return [Enterpirse objectFromDictionary: dict];
}

- (NSString*) currentUserPassword {
    return [self keychainRead:KEY_CURRENT_USER_PWD];
}

- (void) removeCurrentUser {
    [self userDefaultsRemove:KEY_CURRENT_USER];
    [self userDefaultsRemove:KEY_CURRENT_ENT];
    [self keychainDelete:KEY_CURRENT_USER_PWD];
}

@end
