//
//  VankePassengerFlowModel.m
//  vanke
//
//  Created by xiaomi on 15/10/9.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankePassengerFlowModel.h"

@implementation VankePassengerFlowModel

@synthesize projectEquals = _projectEquals;
@synthesize passengerFlowDateEquals = _passengerFlowDateEquals;

-(PassengerFlowResponse*) getServerResp {
    return (PassengerFlowResponse*) self.serverResp;
}

-(void) reload {
    [VankePassengerFlowAPI cancel];
    
    VankePassengerFlowAPI *api = [VankePassengerFlowAPI api];
    
    @weakify(api);
    @weakify(self);
    
    api.projectEquals = self.projectEquals;
    api.passengerFlowDateEquals = self.passengerFlowDateEquals;
    
    // 清空结果
    self.serverResp = nil;
    
    api.whenSucceed = ^{
        @normalize(api);
        @normalize(self);
        
        if (api.sending) {
            [self sendUISignal:self.RELOADING];
        } else {
            if (api.succeed) {
                if (nil == api.serverResp) {
                    api.failed = YES;
                } else {
                    self.serverResp = api.serverResp;
                }
            }
            [self sendUISignal:self.RELOADED];
        }
    };
    api.whenFailed = ^{
        @normalize(api);
        @normalize(self);
        
        self.serverResp = [PassengerFlowResponse initWith:NO message:nil == api.errorDesc ? @"网络异常" : api.errorDesc];
        [self sendUISignal:self.RELOADED];
    };
    [api send];
}

@end
