//
//  VankeUtil.h
//  vanke
//
//  Created by xiaomi on 15/10/5.
//  Copyright © 2015年 gomore. All rights reserved.
//

#ifndef VankeUtil_h
#define VankeUtil_h

#import "Bee.h"

@interface VankeUtil : NSObject

AS_SINGLETON( VankeUtil )

+ (NSString*) getConfigValue: (NSString*) key;

// 去除空格
+ (NSString*) trim: (NSString*) str;

// 判断字符串是否为空
+ (BOOL) isBlankString:(NSString *)string;

// md5加密(小写)
+ (NSString*) md5: (NSString*) src;

// base64
+ (NSString*) base64: (NSString*) src;

// 字典转换成json字符串
+ (NSString*)dictToJsonString:(id)object;

+ (UIColor *)colorWithHexString:(NSString *)stringToConvert;

+ (NSString *)hexToRGB:(NSString *)hexString;

+ (UIColor *)rgbStringToColor:(NSString *)rgbString;

+ (NSString *)getHexStringForColor:(UIColor*)color;

@end


#endif /* VankeUtil_h */
