

#import "VankeFloorListBoardCell_iPhone.h"
#import "VankeUtil.h"

#pragma mark -

@implementation VankeFloorListBoardCell_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIImageView,     imgPhoto )
DEF_OUTLET( BeeUILabel,         lblName )
DEF_OUTLET( BeeUILabel,         lblOpenDate )
DEF_OUTLET( BeeUILabel,         lblSaleAmount )
DEF_OUTLET( BeeUILabel,         lblPassengerFlow )
DEF_OUTLET( BeeUILabel,         lblPrice )

- (BOOL)dataWillChange:(id)newData
{
    return newData != self.data;
}

- (void)dataDidChanged
{
    FloorCellValue * obj = self.data;
    if (nil == obj) {
        return;
    }
    
    ProjectCategory *prj = obj.project;
    if ( prj )
    {
        self.lblName.data = prj.projectName;
        self.imgPhoto.data = [prj getPictureUrlOrDefault];
        self.lblOpenDate.data = prj.foundingDate;
        self.lblSaleAmount.data = prj.salesAmount;
        self.lblPassengerFlow.data = prj.passengerFlowVolume;
        self.lblPrice.data = prj.perCustomerTransaction;
    }
    
    if (obj.cellType == CELL_TYPE_PASSENGER) {
        $(@".floor-ctr").HIDE();
        $(self.lblPassengerFlow).ADD_CLASS(obj.theme);
    } else {
        $(self.lblSaleAmount).ADD_CLASS(obj.theme);
    }
}

@end

#pragma mark - FloorCellValue

@implementation FloorCellValue

@synthesize theme = _theme;
@synthesize project = _project;
@synthesize cellType = _cellType;

@end


