

#import "VankeFloorListBoard_iPhone.h"
#import "PullLoader.h"
#import "FootLoader.h"
#import "VankeUtil.h"
#import "GEToast.h"
#import "NoDataCell_iPhoneCell.h"
#import "VankeProjectListAPI.h"
#import "VankeFloorDetailBoard_iPhone.h"
#import "VankeFloorListBoardCell_iPhone.h"
#import "VankePassengerDetailBoard_iPhone.h"

@interface VankeFloorListBoard_iPhone ()
@end

#pragma mark -

@implementation VankeFloorListBoard_iPhone
{
}

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

@synthesize projectCategory = _projectCategory;
@synthesize projectNameLike = _projectNameLike;
@synthesize salesDate = _salesDate;
//@synthesize passengerFlowDate = _passengerFlowDate;
@synthesize listType = _listType;

DEF_MODEL( VankeProjectListModel, model );
DEF_OUTLET( BeeUIScrollView, list );
DEF_OUTLET( BeeUITextField,  txtQuery);

+ (id)boardWithType: (CellType) type {
    VankeFloorListBoard_iPhone *board = [super board];
    board.listType = type;
    return board;
}

- (void)load
{
    self.model = [VankeProjectListModel modelWithObserver:self];
}

- (void)unload
{
    self.model = nil;
}

#pragma mark -

ON_CREATE_VIEWS( signal )
{
    [UIApplication sharedApplication].statusBarHidden = NO;
    
    self.navigationBarShown = YES;
    self.title = _projectCategory;
    
    [self addLeftIconToTextField:_txtQuery icon:@"search"];
    
    self.allowedSwipeToBack = YES;
    
    self.list.headerClass = [PullLoader class];
    self.list.headerShown = YES;
    
    self.list.footerClass = [FootLoader class];
    self.list.footerShown = YES;
    
    self.list.lineCount = 2;
    self.list.animationDuration = 0.2f;
    self.list.baseInsets = bee.ui.config.baseInsets;
    
    self.list.whenReloading = ^
    {
        self.list.total = self.model.projects.count;
        if (self.model.loaded && self.list.total <= 0) {
            self.list.total = 1;
            BeeUIScrollItem * item = self.list.items[0];
            
            item.size = CGSizeMake( self.list.width, 50);
            item.order = 0;
            item.rule = BeeUIScrollLayoutRule_Fall;
            item.clazz = [NoDataCell_iPhoneCell class];
            item.data = @"没有数据，请稍后重试！";
        } else {
            CGFloat cellHeight = 240;
            if (self.listType == CELL_TYPE_PASSENGER) {
                cellHeight = 200;
            }
            
            for ( BeeUIScrollItem * item in self.list.items )
            {
                item.size = CGSizeMake( self.list.width / self.list.lineCount, cellHeight );
                item.order = 0;
                item.rule = BeeUIScrollLayoutRule_Fall;
                item.clazz = [VankeFloorListBoardCell_iPhone class];
                
                ProjectCategory *prj = [self.model.projects safeObjectAtIndex:item.index];
                FloorCellValue *cellValue = [[FloorCellValue alloc] init];
                cellValue.theme = self.theme;
                cellValue.project = prj;
                cellValue.cellType = self.listType;
                item.data = cellValue;
            }
        }
    };
    self.list.whenReloaded = ^
    {
    };
    
    self.list.whenAnimated = ^
    {
    };
    self.list.whenScrolling = ^
    {
    };
    self.list.whenStop = ^
    {
    };
    self.list.whenHeaderRefresh = ^
    {
        [self.model firstPage];
    };
    self.list.whenFooterRefresh = ^
    {
        [self.model nextPage];
    };
    
    self.model.classificationEquals = _projectCategory;
    self.model.nameLike = _projectNameLike;
    self.model.salesDateEquals = _salesDate;

    $(self.txtQuery).DATA(_projectNameLike);
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    self.navigationBarShown = YES;
    //    [self.list reloadData];
    
    if ( NO == self.model.loaded )
    {
        [self.model firstPage];
    }
    
    [BeeUIRouter sharedInstance].view.pannable = YES;
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = NO;
}

ON_DID_DISAPPEAR( signal )
{
}

ON_SIGNAL3( VankeFloorListBoard_iPhone, txtQuery, signal )
{
    if ([signal is:BeeUITextField.RETURN]) {
        NSString *nameLike = [VankeUtil trim:$(self.txtQuery).data];
        self.model.nameLike = nameLike;
        [self.model firstPage];
    }
}

#pragma mark -

ON_SIGNAL3( VankeFloorListBoardCell_iPhone, mask, signal )
{
    FloorCellValue *cellValue = signal.sourceCell.data;
    
    if (self.listType == CELL_TYPE_PASSENGER) {
        VankePassengerDetailBoard_iPhone * board = [VankePassengerDetailBoard_iPhone board];
        board.data = cellValue.project;
        board.passengerFlowDate = _salesDate;
        board.theme = self.theme;
        [self.stack pushBoard:board animated:YES];
    } else {
        VankeFloorDetailBoard_iPhone *board = [VankeFloorDetailBoard_iPhone board];
        board.data = cellValue.project;
        board.salesDate = _salesDate;
        board.theme = self.theme;
        [self.stack pushBoard:board animated:YES];
    }
    
}

#pragma mark -

ON_SIGNAL3( VankeProjectListModel, RELOADING, signal )
{
    [GEToast showProgress:self.view];
    self.list.headerLoading = YES;
    self.list.footerLoading = YES;
}

ON_SIGNAL3( VankeProjectListModel, RELOADED, signal )
{
    [GEToast hideProgress];
    self.list.headerLoading = NO;
    self.list.footerLoading = NO;
    self.list.footerMore = self.model.more;
    [self.list reloadData];
}

-(void) addLeftIconToTextField: (BeeUITextField*) textField icon: (NSString*) icon {
    UIImageView *img = [[UIImageView alloc] initWithImage:[UIImage imageNamed:icon]];
    img.frame = CGRectMake(0, 0, 35, 25);
    img.contentMode = UIViewContentModeCenter;
    textField.leftView = img;
    textField.leftViewMode = UITextFieldViewModeAlways;
}

@end
