

#import "VankeWeatherCell_iPhone.h"
#import "VankeWeatherController.h"

#pragma mark -

@interface VankeWeatherCell_iPhone()
{
}
@end

@implementation VankeWeatherCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUILabel, lblCityName )
DEF_OUTLET( BeeUILabel, lblWeatherDesc )
DEF_OUTLET( BeeUIImageView, imgWeatherIcon )
DEF_OUTLET( BeeUIButton, btnMask )

DEF_MODEL(VankeWeatherModel, model)

- (void)load
{
    self.model = [VankeWeatherModel modelWithObserver: self];
}

- (void)unload
{
    self.model = nil;
}

-(void) reloadLocationAndWeather {
    [self reloadLocationAndWeather: NO];
}

-(void) reloadLocationAndWeather: (BOOL) force {
    NSString *curCity = @"上海";
 
    if (!force) {
        if([_model loadCache:curCity]) {
            return;
        }
    }
    [_model loadOnline];
}

-(void) refreshUI {
    DayWeather *weather = _model.weather;
    if (weather == nil) {
        return;
    }
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"HH"];
    NSInteger curTime = [[dateFormatter stringFromDate:[NSDate date]] integerValue];
    if (curTime >= 19 || curTime <= 6) {
        $(self.imgWeatherIcon).DATA(weather.nightPictureUrl);
    } else {
        $(self.imgWeatherIcon).DATA(weather.dayPictureUrl);
    }
    
    $(self.lblCityName).DATA(weather.city);
    $(self.lblWeatherDesc).DATA([NSString stringWithFormat:@"%@ %@ %@", weather.weather, weather.wind, weather.temperature]);
}

ON_MESSAGE3(VankeWeatherController, LOAD_WEATHER, msg) {
    if(msg.succeed) {
        DayWeather *weather = _model.weather;
        if (weather) {
            NSLog(@"当前城市: %@, 温度: %@", weather.city, weather.temperature);
            [self refreshUI];
        }
    }
}

@end
