
//
//  LoginBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/9/24.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeLoginBoard_iPhone.h"
//#import "VankeMainBoard_iPhone.h"
#import "AppDelegate.h"
#import "GEToast.h"
#import "VankeUtil.h"

#define PWD_MASK @"                  "

#pragma mark -

@interface VankeLoginBoard_iPhone()
{
	//<#@private var#>
}
@end

@implementation VankeLoginBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUITextField,	txtUserName );
DEF_OUTLET( BeeUITextField,	txtPwd );
DEF_OUTLET( BeeUIButton,	btnLogin );

DEF_MODEL( VankeUserModel, model );
DEF_NOTIFICATION( SUCC_LOGIN )

- (void)load
{
    self.model = [VankeUserModel modelWithObserver: self];
}

- (void)unload
{
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.navigationBarShown = NO;
    [self addLeftIconToTextField:_txtUserName icon: @"user_icon"];
    [self addLeftIconToTextField:_txtPwd icon:@"pwd_icon"];
}

-(void) addLeftIconToTextField: (BeeUITextField*) textField icon: (NSString*) icon {
    UIImageView *img = [[UIImageView alloc] initWithImage:[UIImage imageNamed:icon]];
    img.frame = CGRectMake(0, 0, 50, 20);
    img.contentMode = UIViewContentModeCenter;
    textField.leftView = img;
    textField.leftViewMode = UITextFieldViewModeAlways;
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    self.navigationBarShown = NO;
}

ON_DID_APPEAR( signal )
{
    if ([_model canAutoLogin]) {
        [GEToast showProgress:self.view];
        [_btnLogin setTitle:@"登录中..." forState:UIControlStateSelected];
        [_model autoLogin];
    }
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
    [NSObject cancelPreviousPerformRequestsWithTarget:self];
}

ON_SIGNAL3( VankeLoginBoard_iPhone, btnLogin, signal )
{
    if (![self checkToLogin]) {
        return;
    }
    
    [GEToast showProgress:self.view];
    [_btnLogin setTitle:@"登录中..." forState:UIControlStateSelected];
    [_model login:[self getUserName] password:[self getPassword]];
}

ON_SIGNAL3( VankeUserModel, RELOADING, signal ) {
}

ON_SIGNAL3( VankeUserModel, RELOADED, signal ) {
    [GEToast hideProgress];
    [_btnLogin setTitle:@"登  录" forState:UIControlStateNormal];
    
    if (![_model isOk]) {
        [GEToast showWithText:[_model getMessage] bottomOffset:30 duration:1.0f];
        return;
    }
    
    $(self).FADE_OUT().DURATION( 0.5f ).DELAY( 0.5f ).ON_COMPLETE( ^{
        [self postNotification:self.SUCC_LOGIN];
    });
}

-(BOOL) checkToLogin {
    NSString *userName = [self getUserName];
    if ([VankeUtil isBlankString:userName]) {
        $(_txtUserName).FOCUS();
        return NO;
    }
    
    NSString *pwd = [self getPassword];
    if ([VankeUtil isBlankString:pwd]) {
        $(_txtPwd).FOCUS();
        return NO;
    }
    
    return YES;
}

-(NSString*) getUserName {
     return [VankeUtil trim:_txtUserName.text];
}

-(NSString*) getPassword {
    return [VankeUtil trim:_txtPwd.text];
}

@end
