//
//  VankeProjectListAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeBaseAPI.h"
#import "VankeResponse.h"

@class ProjectListResponse;


/*
 * 查询项目列表
 * http://.../wanke-server/rest/project/queryprojectsby?classificationEquals={classificationEquals}&nameLike={nameLike}&salesDateEquals={salesDateEquals}& passengerDateEquals={passengerDateEquals}&trafficDateEquals={trafficDateEquals}
 */
@interface VankeProjectListAPI : VankeBaseAPI

// 项目分类等于
@property (nonatomic, strong) NSString *classificationEquals;

// 项目名称类似于,可空
@property (nonatomic, strong) NSString *nameLike;

// 销量日期，默认为昨天
@property (nonatomic, strong) NSString *salesDateEquals;

// 客流量日期，默认为今天
@property (nonatomic, strong) NSString *passengerDateEquals;

// 车流量日期，黑夜为今天
@property (nonatomic, strong) NSString *trafficDateEquals;

@end

// 项目汇总信息
@interface ProjectCategory : BeeActiveObject

// 项目名称
@property (nonatomic, strong) NSString *projectClassification;
// 项目ID
@property (nonatomic, strong) NSString *projectId;
// 项目名称
@property (nonatomic, strong) NSString *projectName;
// 创立日期
@property (nonatomic, strong) NSString *foundingDate;
// 销量
@property (nonatomic, strong) NSNumber *salesAmount;
// 客流量
@property (nonatomic, strong) NSNumber *passengerFlowVolume;
// 客单价
@property (nonatomic, strong) NSNumber *perCustomerTransaction;
// 图片URL
@property (nonatomic, strong) NSString *picture;
// 销售日期
@property (nonatomic, strong) NSString *salesDate;


-(NSString*) getPictureUrlOrDefault;

@end

@interface ProjectListResponse : VankeResponse

@property (nonatomic, strong) NSArray *data;

-(int) total;

@end