//
//  IBTFileManager.m
//  Cruiser
//
//  Created by Xummer on 15/6/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTFileManager.h"

@implementation IBTFileManager

// File Size
+ (NSNumber *)sizeForFileAtPath:(NSString *)filePath {
    NSError *attributesError;
    NSDictionary *fileAttributes =
    [[NSFileManager defaultManager] attributesOfItemAtPath:filePath error:&attributesError];
    
    if (!attributesError) {
        return fileAttributes[ NSFileSize ] ? : @(0);
    }
    else {
        return @(0);
    }
}

+ (BOOL)removeFileAtPath:(NSString *)filePath {
    NSFileManager *fileManager = [NSFileManager defaultManager];
    
    NSError *error;
    
    if ([fileManager fileExistsAtPath:filePath]) {
        [fileManager removeItemAtPath:filePath error:&error];
    }
    else {
        return YES;
    }
    
    if (error) {
        NSLog(@"%@",error);
        return NO;
    }
    else{
        return YES;
    }
    
}

+ (BOOL)removeFileAtUrl:(NSURL *)filePathUrl {
    if (!filePathUrl ) {
        return NO;
    }
    
    NSString *filePathStr = [filePathUrl path];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    
    NSError *error;
    
    if ([fileManager fileExistsAtPath:filePathStr]) {
        [fileManager removeItemAtURL:filePathUrl error:&error];
    }
    else {
        return YES;
    }
    
    if (error) {
        NSLog(@"%@",error);
        return NO;
    }
    else{
        return YES;
    }
}

+ (BOOL)moveFile:(NSURL *)fromPath toPath:(NSURL *)toPath
{
    if (!toPath || !fromPath) {
        return NO;
    }
    
    NSString *fromPathStr = [fromPath path];
    NSString *toPathStr = [toPath path];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSError *error = nil;
    if ([fileManager fileExistsAtPath:fromPathStr]) {
        [fileManager moveItemAtPath:fromPathStr toPath:toPathStr error:&error];
    }
    
    if (error) {
        NSLog(@"%@",error);
        return NO;
    }
    else{
        return YES;
    }
}

@end
