
//
//  VankeBaseAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/7.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeBaseAPI.h"
#import "VankeUtil.h"
#import "VankeConfig.h"
#import "VankeCommonModel.h"

#pragma mark -

@implementation VankeBaseAPI

@synthesize serverResp;

- (id) init {
    self = [super init];
    if ( self )
    {
        self.serverResp = nil;
    }
    return self;
}

-(BeeHTTPRequest*) http_post: (NSString*) url {
    NSString *absUrl = [NSString stringWithFormat:@"%@%@", VANKE_SERVER_BASE_URL, url];
    BeeHTTPRequest *req = self.HTTP_POST(absUrl);
    [self addHeaders:req];
    return req;
}

-(BeeHTTPRequest*) http_get: (NSString*) url {
    NSString *absUrl = [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_BASE_URL, url];
    BeeHTTPRequest *req = self.HTTP_GET(absUrl);
    [self addHeaders:req];
    return req;
}

-(void) setClientError: (NSString*) error {
    self.failed = YES;
    [self setLastError:-1 domain:BeeMessage.ERROR_DOMAIN_CLIENT desc:error];
}

-(VankeBaseAPI*) addHeaders: (BeeHTTPRequest*) req {
    req.HEADER(@"Content-Type", @"application/json;charset=utf-8");
    req.HEADER(@"Accept", @"application/json;charset=utf-8");

    Enterpirse *ent = [[VankeCommonModel sharedInstance] currentEnt];
    if (nil != ent && ![VankeUtil isBlankString:ent.uuid]) {
        req.HEADER(@"enterprise", ent.uuid);
    }
    
    NSString *src = [NSString stringWithFormat:@"%@:%@", VANKE_SERVER_USER_NAME, VANKE_SERVER_PASSWORD];
    NSString *auth = [NSString stringWithFormat:@"Basic %@", [VankeUtil base64:src]];
    INFO(auth);
    req.HEADER(@"Authorization", auth);
    
    return self;
}

@end

#pragma Paging

@implementation Paging

@synthesize page = _page;
@synthesize pageSize = _pageSize;
@synthesize pageCount = _pageCount;
@synthesize recordCount = _recordCount;

@end
