//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementDetailMonthCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementDetailMonthCell_iPhone.h"
#import "VankeCommonModel.h"
#import "VankeSettlementListAPI.h"
#import "VankeSettlementSubjectListAPI.h"

#pragma mark -

@implementation VankeStatementDetailMonthCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUILabel,     lblYear )
DEF_OUTLET( BeeUILabel,     lblMonth )
DEF_OUTLET( BeeUILabel,     lblAmount )
DEF_OUTLET( BeeUILabel,     lblTotalPrefix )

- (void)load
{
    
}

- (void)unload
{
}

- (void)dataDidChanged
{
    NSDate *settleDate = nil;
    NSNumber *amount = nil;

    if ([self.data isKindOfClass:[StatementShop class]]) {
        StatementShop *shop = (StatementShop*) self.data;
        if (nil != shop) {
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"yyyy-MM-dd"];
            settleDate = [dateFormatter dateFromString:shop.settle];
            amount = shop.amount;
        }
    } else if ([self.data isKindOfClass:[StatementSubjectListResponseData class]]) {
        StatementSubjectListResponseData *subject = (StatementSubjectListResponseData*) self.data;
        if (nil != subject) {
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"yyyyMM"];
            settleDate = [dateFormatter dateFromString:subject.settle];
            amount = subject.amount;
        }
    }
    
    [self setSettleDate:settleDate];
    $(self.lblAmount).DATA([NSString stringWithFormat:@"%.2f ", nil == amount? 0.0f:[amount doubleValue]]);
    
    VankeCommonModel *model = [VankeCommonModel sharedInstance];
    LoginResponseData *loginInfo = [model getLoginInfo];
    if (nil != loginInfo) {
        if ([USER_POSITION_TENANT eq:loginInfo.position]) {
            $(self.lblTotalPrefix).DATA(@"本期应付金额");
        } else {
            $(self.lblTotalPrefix).DATA(@"本期应收金额");
        }
    }
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

-(void) setSettleDate: (NSDate*) date {
    if (nil == date) {
        $(self.lblYear).DATA(@"");
        $(self.lblMonth).DATA(@"");
    } else {
        $(self.lblYear).DATA([NSString stringWithFormat:@"%lu", date.year]);
        $(self.lblMonth).DATA([NSString stringWithFormat:@"%lu", date.month]);
    }
}

@end

