//
//  VankeNoticeListAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeBaseAPI.h"
#import "VankeResponse.h"

@class NoticeListResponse;


/*
 * 查询项目列表
 * http://.../wanke-server/rest/project/queryprojectsby?classificationEquals={classificationEquals}&nameLike={nameLike}&salesDateEquals={salesDateEquals}& passengerDateEquals={passengerDateEquals}&trafficDateEquals={trafficDateEquals}
 */
@interface VankeNoticeListAPI : VankeBaseAPI

// 发布日期大于等于
@property (nonatomic, strong) NSString *publishTimeBegin;

@end

// 公告信息
@interface Notice : BeeActiveObject

// 标识
@property (nonatomic, strong) NSString *noticeId;
// 标题
@property (nonatomic, strong) NSString *title;
// 发布人
@property (nonatomic, strong) NSString *publisher;
// 发布时间
@property (nonatomic, strong) NSString *publishTime;
// 优先级
@property (nonatomic, strong) NSString *priority;
// 内容
@property (nonatomic, strong) NSString *content;
// 附件
@property (nonatomic, strong) NSString *attachment;
// 是否已读
@property (nonatomic, assign) BOOL readed;

-(NSString*) getAttachmentUrl;

@end

@interface NoticeListResponse : VankeResponse

@property (nonatomic, strong) NSArray *data;

-(int) total;

@end